% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temkinLM.R
\name{temkin.LM}
\alias{temkin.LM}
\title{Temkin Isotherm Linear Analysis}
\usage{
temkin.LM(Ce, Qe, Temp)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}

\item{Temp}{temperature}
}
\value{
the linear regression, parameters for Temkin isotherm, and model
error analysis
}
\description{
Temkin isotherm  is a monolayer adsorption isotherm model which
takes into account the effects that the indirect interaction amongst adsorbate
molecules could have on the adsorption process.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
Temp <- 298.15
temkin.LM(Ce,Qe,Temp)
}
\references{
Temkin, M.J., and Pyzhev, V. (1940). Kinetics of ammonia synthesis
on promoted iron catalyst. Acta Phys. Chim. USSR 12, 327-356.

Foo, K. Y., and Hameed, B. H. (2009, September 13). <doi:10.1016/j.cej.2009.09.013>
Insights into the modeling of adsorption isotherm systems. Chemical Engineering Journal.
}
\author{
Keith T. Ostan

Chester C. Deocaris
}
