% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edsummary.l.R
\name{edsummary.l}
\alias{edsummary.l}
\title{Linear External Diffusion Models Summary}
\usage{
edsummary.l(t, qt, Ct, qinf, Co, m, V, b, sort.by)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}

\item{Ct}{the numerical value for the concentration of the adsorbent at time t}

\item{qinf}{the numerical value for the amount adsorbed at infinite time}

\item{Co}{the numerical value for the initial concentration of the adsorbent}

\item{m}{the numerical value for mass of adsorbent}

\item{V}{the numerical value for volume of solution}

\item{b}{the numerical value or the Langmuir isotherm constant}

\item{sort.by}{the name of the statistical error parameter in which the models are sorted in either increasing or decreasing order. The only accepted arguments are "RMSE" for Relative Mean Square Error, 'MAE' for Mean Absolute Error, 'MSE' for Mean Squared Error, 'RAE' for Relative Absolute Error, 'AIC' for Akaike Information Criterion, 'BIC' for Bayesian Information Criterion, 'R2' for Coefficient of Determination, and 'SE' for Standard Error Estimate. This argument is case-sensitive, and failure to input the correct value will yield a summary of models in alphabetical order.}
}
\value{
the summarized error and parameter values from external diffusion models.
}
\description{
Summarized results of parameter and error values collected from external diffusion models, namely: Boyd External Diffusion, Furusawa and Smith, and Matthews and Weber.
}
\examples{
t  <- c(0,15,30,45,60,75,90,105,120)
qt <- c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
Ct <- c(10.000,8.141,8.056,7.949,7.863,7.799,7.778,7.756,7.692)
edsummary.l(t,qt,Ct,qinf=4.8,Co=10,m=0.05,V=0.1,b=1.3,"SE")
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
