% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorPlot_rollingMean.R
\name{monitorPlot_rollingMean}
\alias{monitorPlot_rollingMean}
\title{Create Individual Value and Rolling Mean Plot}
\usage{
monitorPlot_rollingMean(ws_monitor, monitorID = NULL, width = 3,
  align = "center", data.thresh = 75, tlim = NULL, ylim = NULL,
  localTime = TRUE, shadedNight = FALSE, aqiLines = TRUE,
  gridHorizontal = FALSE, grid24hr = FALSE, grid3hr = FALSE,
  showLegend = TRUE)
}
\arguments{
\item{ws_monitor}{emph{ws_monitor} object}

\item{monitorID}{monitor ID for a specific monitor in the ws_monitor object (optional if only one monitor
in the ws_monitor object)}

\item{width}{number of periods to average (e.g. for hourly data, \code{width = 24} plots 24-hour rolling means)}

\item{align}{alignment of averaging window relative to point being calculated; one of \code{"left|center|right"}}

\item{data.thresh}{minimum number of valid observations required as a percent of \code{width};
NA is returned if insufficicnet valid data to calculate mean}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{ylim}{y limits for the plot}

\item{localTime}{logical specifying whether \code{tlim} is in local time or UTC}

\item{shadedNight}{add nighttime shading}

\item{aqiLines}{horizontal lines indicating AQI levels}

\item{gridHorizontal}{add dashed horizontal grid lines}

\item{grid24hr}{add dashed grid lines at day boundaries}

\item{grid3hr}{add dashed grid lines every 3 hours}

\item{showLegend}{include legend in top left}
}
\description{
Creates a plot of individual (e.g. hourly) and rolling mean PM2.5 values for a specific monitor.
}
\details{
\itemize{
\item{\code{align = 'left'}: Forward roll, using hour of interest and the (\code{width}-1) subsequent hours 
(e.g. 3-hr left-aligned roll for Hr 5 will consist of average of Hrs 5, 6 and 7)}
\item{\code{align = 'right'}: Backwards roll, using hour of interest and the (\code{width}-1) prior hours
(e.g. 3-hr right-aligned roll for Hr 5 will consist of average of Hrs 3, 4 and 5)}
\item{\code{align = 'center'} for odd \code{width}: Average of hour of interest and (\code{width}-1)/2 on either side
(e.g. 3-hr center-aligned roll for Hr 5 will consist of average of Hrs 4, 5 and 6)}
\item{\code{align = 'center'} for even \code{width}: Average of hour of interest and (\code{width}/2)-1 hours prior and 
\code{width}/2 hours after (e.g. 4-hr center-aligned roll for Hr 5 will consist of average of Hrs 4, 5, 6 and 7)}
}
}
\note{
This function attempts to provide a 'publication ready' rolling mean plot.
}
\examples{
N_M <- Northwest_Megafires
Roseburg <- monitor_subset(N_M, tlim=c(20150821, 20150831),
                           monitorIDs=c('410190002'))
monitorPlot_rollingMean(Roseburg, shadedNight=TRUE)
}
\keyword{ws_monitor}

