% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticmap_plotRasterBrick.R
\name{staticmap_plotRasterBrick}
\alias{staticmap_plotRasterBrick}
\title{Plot an RGB rasterBrick}
\usage{
staticmap_plotRasterBrick(rasterBrick = NULL, grayscale = FALSE, ...)
}
\arguments{
\item{rasterBrick}{an RGB rasterBrick object. It is assumed that layer 1
represents red, layer 2 represents green, and layer 3 represents blue.}

\item{grayscale}{logical specifying conversion to grayscale}

\item{...}{arguments passed on to \code{raster::plot()}
(for \code{grayscale = TRUE}) or \code{raster::plotRGB()}
(for \code{grayscale = FALSE})}
}
\description{
Plots the incoming \code{rasterBrick}.
}
\examples{
\dontrun{
# Fail gracefully if any resources are not available
try({

rasterBrick <- staticmap_getStamenmapBrick(-122.3318, 47.668)
staticmap_plotRasterBrick(rasterBrick)
staticmap_plotRasterBrick(rasterBrick, grayscale = TRUE)

}, silent = FALSE)
}

}
\seealso{
\code{\link{staticmap_getStamenmapBrick}}
}
\keyword{plotting}
