% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_loadLatest.R
\name{airsis_loadLatest}
\alias{airsis_loadLatest}
\title{Load most recent AIRSIS monitoring data}
\usage{
airsis_loadLatest(parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring/latest/RData",
  dataDir = NULL)
}
\arguments{
\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for 'daily' AirNow data files.}

\item{dataDir}{Local directory containing 'daily' data files.}
}
\value{
A \emph{ws_monitor} object with AIRSIS data.
}
\description{
Loads pre-generated .RData files containing the most recent
AIRSIS data.

If \code{dataDir} is defined, data will be loaded from this local
dirctory. Otherwise, data will be loaded from the monitoring data repository
maintained by PWFSL.

The  files loaded by this function are updated multiple times an hour and
contain data for the previous 10 days.

For daily updates covering the most recent 45 days, use \code{airsis_loadDaily()}.

For data extended more than 45 days into the past, use \code{airsis_loadAnnual()}.

AIRSIS parameters include the following:
\enumerate{
\item{PM2.5}
}

Avaialble RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/AIRSIS/RData/latest}{https://haze.airfire.org/monitoring/AIRSIS/RData/latest}
}
\examples{
\dontrun{
airsis_loadLatest() \%>\%
  monitor_subset(stateCodes=CONUS) \%>\%
  monitor_map()
}
}
\seealso{
\code{\link{airsis_loadAnnual}}

\code{\link{airsis_loadDaily}}
}
\keyword{AIRSIS}
