% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PoissonRE.R
\name{PoissonRE}
\alias{PoissonRE}
\title{A Poisson Model with Random Effects}
\usage{
PoissonRE(formula, id, data = NULL, par = NULL, sigma = 1,
  max_sigma = 3, method = "BFGS", lower = NULL, upper = NULL, H = 20,
  accu = 10, reltol = 1e-08, verbose = 0, tol_gtHg = Inf)
}
\arguments{
\item{formula}{Formula of the model}

\item{id}{A vector that represents the identity of individuals, numeric or character}

\item{data}{Input data, a data frame}

\item{par}{Starting values for estimates}

\item{sigma}{Variance of random effects on the individual level}

\item{max_sigma}{Largest allowed initial sigma}

\item{method}{Searching algorithm, don't change default unless you know what you are doing}

\item{lower}{Lower bound for estiamtes}

\item{upper}{Upper bound for estimates}

\item{H}{A vector of length 2, specifying the number of points for inner and outer Quadratures}

\item{accu}{L-BFGS-B only, 1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}

\item{reltol}{Relative convergence tolerance. default typically 1e-8}

\item{verbose}{Level of output during estimation. Lowest is 0.}

\item{tol_gtHg}{tolerance on gtHg, not informative for L-BFGS-B}
}
\value{
A list containing the results of the estimated model
}
\description{
Estimate a Poisson model with random effects in panel counting data. Note this model is different with the Poisson Lognormal model for counting data.
}
\examples{
\donttest{
data(rt)
est = PoissonRE(num.words~fans+tweets+as.factor(tweet.id),
                     id=rt$user.id[rt$isRetweet==1],
                     data=rt[rt$isRetweet==1,])
}
}
\seealso{
Other PanelCount: \code{\link{CRE_SS}}; \code{\link{CRE}};
  \code{\link{PLN_RE}}; \code{\link{ProbitRE}}
}

