% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{IDA_stable}
\alias{IDA_stable}
\title{Estimate  Total Causal Effects}
\usage{
IDA_stable(datacsv, cause, effect, pcmethod, alpha)
}
\arguments{
\item{datacsv}{The dataset in csv format with rows are samples and columns are variables}

\item{cause}{The number of integer positions of the cause variables in the dataset}

\item{effect}{The number of integer positions of the target variables  in the dataset.}

\item{pcmethod}{Character string specifying method; the default, "stable", provides an order-independent skeleton. See Colombo, 2014.}

\item{alpha}{significance level (number in (0; 1) for the individual conditional independence tests.}
}
\value{
A matrix that shows the causal effects (minimum of all possible effects) of the causes (columns) on the effects (rows).
}
\description{
This the stable version (using stable-PC for structure learning) of the IDA algorithm in the pcalg package.
}
\examples{
##########################################
## Using IDA_stable
##########################################
library(pcalg)
data("gmI")
datacsv <- cov(gmI$x)
IDA_stable(datacsv,1:2,3:4,"stable",0.01)
}
\references{
1. Marloes H Maathuis, Markus Kalisch, Peter Buhlmann, et al. Estimating high-dimensional
intervention effects from observational data. The Annals of Statistics, 37(6A):3133-3164,2009.

2. Diego Colombo and Marloes H Maathuis. Order-independent constraint-based causal structure learning. The Journal of Machine Learning Research, 15(1):3741-3782, 2014.
}

