% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{qPiecewisePareto}
\alias{qPiecewisePareto}
\title{Quantile Function of the Piecewise Pareto Distribution}
\usage{
qPiecewisePareto(p, t, alpha, truncation = NULL, truncation_type = "lp")
}
\arguments{
\item{p}{Numeric. The function evaluates the quantile function at \code{p}.}

\item{t}{Numeric vector. Thresholds of the piecewise Pareto distribution.}

\item{alpha}{Numeric vector. \code{alpha[i]} is the Pareto alpha in excess of \code{t[i]}.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the distribution is truncated at \code{truncation}.}

\item{truncation_type}{Character. If \code{truncation_type = "wd"} then the whole distribution is truncated. If \code{truncation_type = "lp"} then a truncated Pareto is used for the last piece.}
}
\value{
Quantile function of the piecewise Pareto distribution with parameter vectors \code{t} and \code{alpha} evaluated at \code{p}
}
\description{
Calculates the quantile function of a piecewise Pareto distribution
}
\examples{
t <- c(1000, 2000, 3000)
alpha <- c(1, 1.5, 2)
p <- 0:10 * 0.1
qPiecewisePareto(p, t, alpha)
qPiecewisePareto(p, t, alpha, truncation = 5000, truncation_type = "lp")
qPiecewisePareto(p, t, alpha, truncation = 5000, truncation_type = "wd")

}
