% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{pPiecewisePareto}
\alias{pPiecewisePareto}
\title{Distribution Function of the Piecewise Pareto Distribution}
\usage{
pPiecewisePareto(x, t, alpha, truncation = NULL, truncation_type = "lp")
}
\arguments{
\item{x}{Numeric. The function evaluates the CDF at \code{x}.}

\item{t}{Numeric vector. Thresholds of the piecewise Pareto distribution.}

\item{alpha}{Numeric vector. \code{alpha[i]} is the Pareto alpha in excess of \code{t[i]}.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the distribution is truncated at \code{truncation}.}

\item{truncation_type}{Character. If \code{truncation_type = "wd"} then the whole distribution is truncated. If \code{truncation_type = "lp"} then a truncated Pareto is used for the last piece.}
}
\value{
Distribution function of the piecewise Pareto distribution with parameter vectors \code{t} and \code{alpha} evaluated at \code{x}
}
\description{
Calculates the cumulative distribution function of a Piecewise Pareto Distribution
}
\examples{
t <- c(1000, 2000, 3000)
alpha <- c(1, 1.5, 2)
x <- 0:10 * 1000
pPiecewisePareto(x, t, alpha)
pPiecewisePareto(x, t, alpha, truncation = 5000, truncation_type = "lp")
pPiecewisePareto(x, t, alpha, truncation = 5000, truncation_type = "wd")

}
\references{
Riegel, U. (2018) Matching tower information with piecewise Pareto. European Actuarial Journal 8(2): 437--460
}
