% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPPModel.R
\name{PPP_Model_Exp_Layer_Loss}
\alias{PPP_Model_Exp_Layer_Loss}
\title{Expected Loss of a Reinsurance Layer}
\usage{
PPP_Model_Exp_Layer_Loss(Cover, AttachmentPoint, PPP_Model)
}
\arguments{
\item{Cover}{Numeric. Cover of the reinsurance layer. Use \code{Inf} for unlimited layers.}

\item{AttachmentPoint}{Numeric. Attachment point of the reinsurance layer.}

\item{PPP_Model}{PPP_Model object.}
}
\value{
The expected loss of the layer \code{Cover} xs \code{AttachmentPoint} for the given \code{PPP_Model}
}
\description{
Calculates the expected loss of a reinsurance layer for a PPP_Model. This function is deprecated. Use \code{Layer_Mean} instead.
}
\examples{
PPPM <- PiecewisePareto_Match_Layer_Losses(Example1_AP, Example1_EL)
PPPM
Example1_Cov <- c(diff(Example1_AP), Inf)
Example1_AP
Example1_Cov
Example1_EL
Layer_Mean(PPPM, Example1_Cov, Example1_AP)

}
