% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExternalValidatePlp.R
\name{externalValidateDbPlp}
\alias{externalValidateDbPlp}
\title{externalValidateDbPlp - Validate a model on new databases}
\usage{
externalValidateDbPlp(
  plpModel,
  validationDatabaseDetails = createDatabaseDetails(),
  validationRestrictPlpDataSettings = createRestrictPlpDataSettings(),
  settings = createValidationSettings(recalibrate = "weakRecalibration"),
  logSettings = createLogSettings(verbosity = "INFO", logName = "validatePLP"),
  outputFolder = NULL
)
}
\arguments{
\item{plpModel}{The model object returned by runPlp() containing the trained model}

\item{validationDatabaseDetails}{A list of objects of class \code{databaseDetails} created using \code{createDatabaseDetails}}

\item{validationRestrictPlpDataSettings}{A list of population restriction settings created by \code{createRestrictPlpDataSettings()}}

\item{settings}{A settings object of class \code{validationSettings} created using \code{createValidationSettings}}

\item{logSettings}{An object of \code{logSettings} created using \code{createLogSettings}
specifying how the logging is done}

\item{outputFolder}{The directory to save the validation results to (subfolders are created per database in validationDatabaseDetails)}
}
\value{
An externalValidatePlp object containing the following components
\itemize{
\item model: The model object
\item executionSummary: A list of execution details
\item prediction: A dataframe containing the predictions
\item performanceEvaluation: A dataframe containing the performance metrics
\item covariateSummary: A dataframe containing the covariate summary
}
}
\description{
This function extracts data using a user specified connection and cdm_schema, applied the model and then calcualtes the performance
}
\details{
Users need to input a trained model (the output of runPlp()) and new database connections. The function will return a list of length equal to the
number of cdm_schemas input with the performance on the new data
}
\examples{
\dontshow{if (rlang::is_installed("Eunomia") && rlang::is_installed("curl") && curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000, seed = 42)
# first fit a model on some data, default is a L1 logistic regression
saveLoc <- file.path(tempdir(), "development")
results <- runPlp(plpData, 
                  outcomeId = 3,
                  saveDirectory = saveLoc,
                  populationSettings = 
                   createStudyPopulationSettings(requireTimeAtRisk=FALSE)
                  )
connectionDetails <- Eunomia::getEunomiaConnectionDetails()
Eunomia::createCohorts(connectionDetails)
# now validate the model on Eunomia
validationDatabaseDetails <- createDatabaseDetails(
  connectionDetails = connectionDetails,
  cdmDatabaseSchema = "main",
  cdmDatabaseName = "main",
  cohortDatabaseSchema = "main",
  cohortTable = "cohort",
  outcomeDatabaseSchema = "main",
  outcomeTable = "cohort",
  targetId = 1, # users of celecoxib
  outcomeIds = 3, # GIbleed
  cdmVersion = 5)
path <- file.path(tempdir(), "validation")
externalValidateDbPlp(results$model, validationDatabaseDetails, outputFolder = path)
# clean up
unlink(saveLoc, recursive = TRUE)
unlink(path, recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
