% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{pet.getRandom}
\alias{pet.getRandom}
\title{Returns a randomly selected pet record. The possible result can be filtered 
with input parameters.}
\usage{
pet.getRandom(records = NULL, animal = NULL, breed = NULL, size = NULL,
  sex = NULL, location = NULL, shelterId = NULL, output = NULL,
  return_df = FALSE)
}
\arguments{
\item{records}{Selects the amount of desired random results to be returned. 
Each returned record is counted as one call to the Petfinder API.}

\item{animal}{Return breeds of animal. Must be one of 'barnyard', 'bird',
'cat', 'dog', 'horse', 'reptile', or 'smallfurry'.}

\item{breed}{Specifies the breed of the animal to search.}

\item{size}{Specifies the size of the animal/breed to search. Must be one of 
'S' (small), 'M' (medium), 'L' (large), 'XL' (extra-large).}

\item{sex}{Filters the search to the desired gender of the animal. Must be 
one of 'M' (male) or 'F' (female).}

\item{location}{ZIP/postal code, state, or city and state to perform the
search.}

\item{shelterId}{Filters randomly returned results down to a specific 
shelter.}

\item{output}{Sets the amount of information returned in each record. 'basic'
returns a simple record while 'full' returns a complete record with 
description. Defaults to 'basic'.}

\item{return_df}{If TRUE, the function will coerce the output JSON from the
Petfinder API into a data.frame}
}
\value{
data.frame of randomly selected pet record(s).
}
\description{
Returns a randomly selected pet record. The possible result can be filtered 
with input parameters.
}
\examples{
\dontrun{
#' pf <- Petfinder(key) # Initialize Petfinder class
pf$pet.getRandom(animal = 'cat')
pf$pet.getRandom(10, 'dog')
}
}
