#' The phase-type distribution
#'
#' Generator functions for the S3 classes \code{cont_phase_type}, \code{disc_phase_type},
#' \code{mult_cont_phase_type}, \code{mult_disc_phase_type}, which represent the
#' different phase-type distributions.
#'
#' @details
#'
#' \code{PH}, \code{DPH}, \code{MPH} and \code{MDPH} are the generator functions
#' for the four types of phase-type distribution
#' classes, this is, the continuous univariate, the discrete univariate, the continuous multivariate
#' and the discrete multivariate respectively.
#' The class is generated by supplying a sub-intensity matrix and an optional
#' initial probability vector plus a reward matrix in the case of multivariate
#' phase-type.
#' If the initial probabilities are not specified, then the initial probability
#' will be \code{init_probs = c(1, 0, 0, ...)} with the same length as the
#' number of transient states.
#'
#' @return A phase-type object of class \code{cont_phase_type} for \code{PH}, \code{disc_phase_type} for \code{DPH},
#' \code{mult_cont_phase_type} for \code{MPH}, and \code{mult_disc_phase_type} for \code{MDPH}.
#' All these classes inherit from \code{list}.
#'
#' @param subint_mat a square matrix containing the transition rates or
#'   probabilities between transient states for continuous or discrete
#'   phase-type respectively.
#'   If the phase-type is continuous, the sub-intensity matrix diagonal should
#'   only contain negative values and the row sums should be non-positive.
#'   If the phase-type is discrete, the sub-intensity matrix should only contain
#'   values between 0 and 1.
#' @param init_probs a vector, a one-row matrix or \code{NULL} which gives the
#'   probabilities to start in each state. If \code{init_probs} is \code{NULL},
#'   the probability to start on the first state will be 1 and 0 otherwise.
#' @param reward_mat a matrix \code{NULL}(default) where each row is a reward
#'   vector, and each column corresponds to a state. It should have the same
#'   number of columns as the length of the initial probabilities.
#'
#' @name generator_functions
#' @order 1
NULL

