% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populationDiagnostics.R
\name{populationDiagnostics}
\alias{populationDiagnostics}
\title{Population-level diagnostics}
\usage{
populationDiagnostics(
  cohort,
  populationSample = 1e+06,
  populationDateRange = as.Date(c(NA, NA))
)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}

\item{populationSample}{Number of people from the cdm to sample. If NULL no
sampling will be performed. Sample will be within populationDateRange if
specified.}

\item{populationDateRange}{Two dates. The first indicating the earliest cohort
start date and the second indicating the latest possible cohort end date. If
NULL or the first date is set as missing, the earliest observation_start_date
in the observation_period table will be used for the former. If  NULL or the
second date is set as missing, the latest observation_end_date in the
observation_period table will be used for the latter.}
}
\value{
A summarised result
}
\description{
phenotypeR diagnostics on the cohort of input with relation to a denomination
population. Diagnostics include:

* Incidence
* Prevalence
}
\examples{
\donttest{
library(omock)
library(CohortConstructor)
library(PhenotypeR)

cdm <- mockCdmFromDataset(source = "duckdb")
cdm$warfarin <- conceptCohort(cdm,
                              conceptSet =  list(warfarin = c(1310149L,
                                                              40163554L)),
                              name = "warfarin")

result <- cdm$warfarin |>
  populationDiagnostics()

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
