% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_step.R
\name{compute_E.simple}
\alias{compute_E.simple}
\title{E step}
\usage{
compute_E.simple(phylo, times_shared, distances_phylo, process, params_old,
  masque_data = c(rep(TRUE, attr(params_old, "p_dim") *
  length(phylo$tip.label)), rep(FALSE, attr(params_old, "p_dim") *
  phylo$Nnode)), F_moments, Y_data_vec_known, miss = rep(FALSE,
  attr(params_old, "p_dim") * length(phylo$tip.label)), Y_data, U_tree, ...)
}
\arguments{
\item{phylo}{Input tree.}

\item{Y_data}{: vector indicating the data at the tips}

\item{sim}{(list) : result of function \code{simulate}}

\item{Sigma}{: variance-covariance matrix, result of function \code{compute_variance_covariance}}

\item{Sigma_YY_inv}{: invert of the variance-covariance matrix of the data}
}
\value{
conditional_law_X (list) : list of conditional statistics :
                  "expectation" : matrix of size p x (ntaxa+nNodes), with ntaxa
first columns set to Y_data (tips), and from ntaxa+1 to conditional expectation
of the nodes conditioned to the tips E[Z_j|Y]
                  "variances" : array of size p x p x (ntaxa+nNodes) with ntaxa first 
matrices of zeros (tips) and conditional variance of the nodes conditioned to the tips 
Var[Z_j|Y]
                 "covariances" : array of size p x p x (ntaxa+nNodes) with ntaxa first 
matrices of zeros (tips) and conditional covariance of the nodes and their parents
conditioned to the tips Cov[Z_j,Z_pa(j)|Y], with NA for the root.
                  "optimal.values" : matrix of size p x ntaxa+nNodes of optimal
values beta(t_j)
}
\description{
\code{compute_E.simple} computes the E step in the simple case where the invert matrix Sigma_YY_inv is given
}
\details{
This function takes parameters sim, Sigma and Sigma_YY_inv from  
\code{compute_mean_variance.simple}. It uses functions 
\code{extract.variance_covariance}, \code{extract.covariance_parents}, and
 \code{extract_simulate_internal} to extract the needed quantities from these objects.
}
\keyword{internal}
