% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_heterogeneous.R
\name{AntibodyForests_heterogeneous}
\alias{AntibodyForests_heterogeneous}
\title{Bipartite sequence-cell networks in AntibodyForests}
\usage{
AntibodyForests_heterogeneous(
  trees,
  GEX.object,
  node.features,
  cell.graph.type,
  recluster.cells,
  recluster.resolution,
  snn.threshold,
  keep.largest.cc,
  parallel
)
}
\arguments{
\item{trees}{AntibodyForests object/list of AntibodyForests objects - the resulting sequence similarity or minimum spanning tree networks from the AntibodyForests function.}

\item{GEX.object}{Seurat object/ VGM[[2]] for the inferred AntibodyForests networks (must include all cells available in the AntibodyForests object).}

\item{node.features}{vector of strings - gene names in the Seurat object to be added as igraph vertex attributes in the resulting heterogeneous networks (will add gene expression per gene).}

\item{cell.graph.type}{string - graph algorithm for building the cell-cell/ nearest-neighbour graphs, as done by the Seurat::FindNeighbors() function. 'knn' for the K nearest-neighbour graphs, 'snn' for the shared nearest-neighbour graphs.}

\item{recluster.cells}{boolean - whether to recluster the resulting cell graphs or keep the already existing Seurat cluster definitions.}

\item{recluster.resolution}{numeric - recluster resolution for the Louvain algorithm if recluster.cells is TRUE.}

\item{snn.threshold}{numeric - SNN edge weight threshold to further prune edges in the cell graphs (increased value = sparser cell graphs). Defaults to 1/15 (as done in the Seurat::FindNeighbors function).}

\item{keep.largest.cc}{boolean - whether to keep only the largest connected component in the cell graphs or keep all singletons/doubletons/etc., as well.}

\item{parallel}{boolean - whether to execute the heterogeneous graph building algorithm in parallel or not. Requires the 'parallel' R package.}
}
\value{
nested list of AntibodyForests objects for each clonotype and each sample/timepoint or a single AntibodyForests object, with a new added object slot for the heterogeneous graph.
}
\description{
Creates a bipartite network from a Seurat object and an already inferred AntibodyForests sequence similarity/ minimum spanning tree network.
}
\examples{
\dontrun{
AntibodyForests_heterogeneous(trees, GEX.object = VGM[[2]], cell.graph.type = 'snn')
}
}
