% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_GEX_stats.R
\name{VDJ_GEX_stats}
\alias{VDJ_GEX_stats}
\title{Standalone VDJ and GEX statistics.}
\usage{
VDJ_GEX_stats(
  VDJ.out.directory,
  GEX.out.directory,
  sample.names,
  metrics10x,
  save.csv,
  filename
)
}
\arguments{
\item{VDJ.out.directory}{List of paths with each element containing the path to the output of cellranger VDJ runs. This pipeline assumes that the output file names have not been changed from the default 10x settings in the /outs/ folder. This is compatible with B and T cell repertoires (both separately and simultaneously).}

\item{GEX.out.directory}{OPTIONAL list of paths with each element containing the path to the output of cellranger GEX runs. This pipeline assumes that the output file names have not been changed from the default 10x settings in the /outs/ folder. This is compatible with B and T cell repertoires (both separately and simultaneously).}

\item{sample.names}{OPTIONAL: an array of the same length as the input VDJ.out.directory list with custom names for each sample. If not provided samples will be numbered by processing order}

\item{metrics10x}{Whether to append metrics_summary.csv information provided by Cellranger for both VDJ and GEX. Defaults to T}

\item{save.csv}{Boolean. Defaults to TRUE. Whether to directly save the resuts as a comma delimited .csv file in the current working directory.}

\item{filename}{Character ending in .csv. Filename to save .csv as.}
}
\value{
returns a single matrix where the rows are individual cells and the columns are repertoire features.
}
\description{
Gives stats on number and quality of reads. This function is integrated into the VDJ_GEX_matrix. Before running, please check list element [[3]] of VDJ_GEX_matrix output for already generated statistics.
}
\examples{
\donttest{
try({
stats <- VDJ_GEX_stats(VDJ.out.directory = VDJ.out.directory.list
,GEX.out.directory = GEX.out.directory.list,sample.names = c(1:4)
,metrics10x = TRUE,save.csv = FALSE)
})
}
}
