% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectrumLegend.R
\name{SpectrumLegend}
\alias{SpectrumLegend}
\alias{SizeLegend}
\title{Produce a legend for continuous gradient scales}
\usage{
SpectrumLegend(
  x = "topright",
  ...,
  legend,
  lty = 1,
  lwd = 4,
  bty = "o",
  palette,
  adj = if (horiz) c(0.5, 0.5) else c(0, 0.5),
  horiz = FALSE,
  lend = "square",
  cex = 1,
  seg.len = 1
)

SizeLegend(
  x = "topright",
  ...,
  legend = character(0),
  width = c(0, 1),
  palette = par("col"),
  scale = c("pch", "lwd"),
  lty = 0,
  lwd = 4,
  bty = "o",
  adj = if (horiz) c(0.5, 0.5) else c(0, 0.5),
  horiz = FALSE,
  lend = "butt",
  cex = 1,
  seg.len
)
}
\arguments{
\item{x, horiz, adj, seg.len, \dots}{Additional parameters to \code{\link[=legend]{legend()}}.}

\item{legend}{Character vector with which to label points on \code{palette}.
Note that, in a vertical legend, values will be printed from top down;
use \code{\link[=rev]{rev()}} to reverse the order.}

\item{lwd, lty, lend}{Additional parameters to \code{\link[=segments]{segments()}},
controlling line style.}

\item{bty}{Character specifying the type of box to be drawn around the
legend. The allowed values are \code{"o"} (the default) and \code{"n"}.}

\item{palette}{Colour palette to depict.
Specify either a vector of colours, or a function such that \code{palette(n)}
returns a vector of \emph{n} colours.}

\item{cex}{Character expansion factor relative to current \code{par("cex")}.}

\item{width}{Vector of length two specifying width of legend bar at base
and top.}

\item{scale}{Character string specifying whether \code{width = 1} corresponds to:
\code{"pch"}, the size of a plotting symbol with \code{pch = 1};
\code{"lwd"}, the width of a line with \code{lwd = 1}.}

\item{col}{Colour used for the width bar.}
}
\value{
A list, returned invisibly, with components:
\itemize{
\item \code{rect} A list with components:
\itemize{
\item \code{w}, \code{h}: positive numbers giving \emph{w}idth and \emph{h}eight of the
legend's box.
\item \code{left}, \code{top}: x and y coordinates of the upper left corner of the
box.
}
\item \code{text}: A list with components \code{x}, \code{y}, numeric vectors of length
\code{length(legend)}, giving the x and y coordinates of the legend's text(s).
}
}
\description{
Prints an annotated vertical bar coloured according to a continuous palette.
}
\details{
This convenience function is not yet very customizable; do file a GitHub
issue if you would value additional functionality.

Note that the \code{bg} parameter to specify the background colour for the legend
box is not presently supported in vertical legends.
For use in vertical legends, open a \href{https://github.com/ms609/PlotTools/issues/new}{GitHub issue}.
}
\examples{
plot(0:1, 0:1, type = "n", frame.plot = FALSE,
     xlab = "x", ylab = "y")

SpectrumLegend("bottomright", legend = c("Bright", "Middle", "Dark"),
               palette = hcl.colors(32L), lwd = 5,
               inset = 0.05, # Inset from plot margin
               title = "Brightness")
SpectrumLegend("topright", horiz = TRUE,
               legend = seq(1, 9, by = 2), palette = 1:8)
SizeLegend(
  "topleft", inset = 0.05, width = c(0, 2),
  title = "Width",
  legend = c("max", ".", ".", "min"),
  palette = topo.colors, # Associate with a colour scale
  y.intersp = 1.5 # Vertical space between labels (also moves title)
)
SizeLegend(
  "bottomleft", horiz = TRUE, width = c(4, 1),
  legend = c("Thick", "Thin"), palette = "darkred",
  inset = 0.06 # Make space for the bar.
               # A future release may calculate this automatically
)
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
