% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Orthogonal_polynomials.R
\name{poly_orth}
\alias{poly_orth}
\alias{poly.orth}
\title{Simpl orthogonal polynomials}
\usage{
poly_orth(x, degree = length(unique(x)) - 1, norm = TRUE)

poly.orth(...)
}
\arguments{
\item{x}{A numeric vector}

\item{degree}{The desired maximum degree}

\item{norm}{Logical: should polynomials be normalised to length one?}

\item{...}{Arguments passed on to the non-deprecated function.}
}
\value{
A list of orthogonal polynomials as a polylist object
}
\description{
Generate a list of polynomials up to a specified degree,
orthogonal with respect to the natural inner product on
a discrete, finite set of x-values with equal weights.
}
\examples{
x <- c(0:3, 5)
P <- poly_orth(x)
plot(P, lty = "solid")
Pf <- as.function(P)
zap(crossprod(Pf(x)))
}
