% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolynomF.R
\name{Ops.polynom}
\alias{Ops.polynom}
\alias{Ops.polylist}
\title{Polynomial arithmetic}
\usage{
\method{Ops}{polynom}(e1, e2)

\method{Ops}{polylist}(e1, e2)
}
\arguments{
\item{e1, e2}{A numeric vector of a polynomial object. At least one of \code{e1}
or \code{e2} must be an object of class \code{"polynom"} or
\code{"polylist"}.}
}
\value{
A polynomial or polylist object representing the result of the operation.
}
\description{
Group generic function to implement arithmetic operations on polynomial objects
}
\examples{
x <- polynomial()
(p <- (x-1)^5 - 1)
(p1 <- (p + 1)/(x - 1)^2 - 1)
for(i in 0:10) cat(coef((x+1)^i), "\n")
}
