% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_mean.R
\name{mc_mean}
\alias{mc_mean}
\title{Compute the monte-carlo mean of a function}
\usage{
mc_mean(ofv_fcn, poped.db, bpopdescr = poped.db$parameters$bpop,
  ddescr = poped.db$parameters$d, doccdescr = poped.db$parameters$d,
  user_distribution_pointer = poped.db$model$user_distribution_pointer,
  ED_samp_size = poped.db$settings$ED_samp_size,
  bLHS = poped.db$settings$bLHS, ...)
}
\arguments{
\item{ofv_fcn}{A function with poped.db as the first input}

\item{poped.db}{A PopED database.}

\item{bpopdescr}{Matrix defining the fixed effects, per row (row number =
parameter_number) we should have: \itemize{ \item column 1 the type of the
distribution for E-family designs (0 = Fixed, 1 = Normal, 2 = Uniform, 3 =
User Defined Distribution, 4 = lognormal and 5 = truncated normal) \item
column 2  defines the mean. \item column 3 defines the variance of the
distribution (or length of uniform distribution). }}

\item{ddescr}{Matrix defining the diagonals of the IIV (same logic as for
the \code{bpopdescr}).}

\item{doccdescr}{Matrix defining the IOV.
per row (row number = parameter_number) we should have:
\itemize{
\item column 1 the type of the distribution for E-family designs (0 = Fixed, 1 = Normal, 2 = Uniform,
 3 = User Defined Distribution, 4 = lognormal and 5 = truncated normal)
\item column 2  defines the mean of the variance.
\item column 3 defines the variance of the distribution (or length of uniform distribution).
}}

\item{user_distribution_pointer}{Function name for user defined distributions for E-family designs}

\item{ED_samp_size}{Sample size for E-family sampling}

\item{bLHS}{How to sample from distributions in E-family calculations. 0=Random Sampling, 1=LatinHyperCube --}

\item{...}{Other arguments passed to the function.}
}
\value{
The mean of the function evaluated at different parameter values.
}
\description{
Function computes the monte-carlo mean of a function by varying the parameter inputs to the function
}
