/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import com.portfolioeffect.quant.client.util.Console;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ArrayCache {
    private File file;
    private int size;
    private ObjectInputStream inStream = null;
    private ObjectOutputStream outStream = null;
    private int[] dimensions = new int[]{1};
    private boolean isAllZero = true;
    private ArrayCacheType type;
    private boolean inUse = false;

    public ArrayCacheType getType() {
        return this.type;
    }

    public ArrayCache(ArrayCacheType type) throws IOException {
        this.type = type;
        this.size = 0;
        this.file = File.createTempFile("quant", "tmp");
        this.file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(this.file);
        this.outStream = new ObjectOutputStream(new BufferedOutputStream(out));
    }

    public ArrayCache(double[] value) throws IOException {
        this(ArrayCacheType.DOUBLE_VECTOR);
        this.write(value);
        this.closeOut();
    }

    public ArrayCache(double[][] value) throws IOException {
        this(ArrayCacheType.DOUBLE_MATRIX);
        this.dimensions = new int[]{value[0].length};
        int i = 0;
        while (i < value.length) {
            this.write(value[i]);
            ++i;
        }
        this.closeOut();
    }

    public ArrayCache(float[] value) throws IOException {
        this(ArrayCacheType.DOUBLE_VECTOR);
        this.writeAsDouble(value);
        this.closeOut();
    }

    public ArrayCache(long[] value) throws IOException {
        this(ArrayCacheType.LONG_VECTOR);
        this.write(value);
        this.closeOut();
    }

    public ArrayCache(int[] value) throws IOException {
        this(ArrayCacheType.INT_VECTOR);
        this.write(value);
        this.closeOut();
    }

    public int getSize() {
        return this.size;
    }

    public void closeOut() throws IOException {
        if (this.outStream != null) {
            this.outStream.flush();
            this.outStream.close();
            this.outStream = null;
        }
    }

    public void openInput() throws IOException {
        if (this.outStream != null) {
            this.closeOut();
        }
        if (this.inUse) {
            this.closeInput();
            this.openInput();
            return;
        }
        this.inUse = true;
        try {
            FileInputStream in = new FileInputStream(this.file);
            this.inStream = new ObjectInputStream(new BufferedInputStream(in));
        }
        catch (Exception e) {
            Console.writeStackTrace(e);
        }
    }

    public double getNextDouble() throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        return this.inStream.readDouble();
    }

    public void closeInput() throws IOException {
        if (this.inUse) {
            if (this.inStream != null) {
                this.inStream.close();
            }
            this.inStream = null;
        }
        this.inUse = false;
    }

    public void write(double[] value) throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        double[] dArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            double e = dArray[n2];
            this.isAllZero = this.isAllZero && e == 0.0;
            this.outStream.writeDouble(e);
            ++n2;
        }
    }

    public void write(float[] value) throws IOException {
        if (this.type != ArrayCacheType.FLOAT_VECTOR && this.type != ArrayCacheType.FLOAT_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        float[] fArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            float e = fArray[n2];
            this.isAllZero = this.isAllZero && (double)e == 0.0;
            this.outStream.writeFloat(e);
            ++n2;
        }
    }

    public void writeAsDouble(float[] value) throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        int i = 0;
        while (i < value.length) {
            double x = value[i];
            this.isAllZero = this.isAllZero && x == 0.0;
            this.outStream.writeDouble(x);
            ++i;
        }
    }

    public void writeAsFloat(double[] value) throws IOException {
        if (this.type != ArrayCacheType.FLOAT_VECTOR && this.type != ArrayCacheType.FLOAT_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        double[] dArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            double e = dArray[n2];
            this.isAllZero = this.isAllZero && e == 0.0;
            this.outStream.writeFloat((float)e);
            ++n2;
        }
    }

    public void write(int[] value) throws IOException {
        if (this.type != ArrayCacheType.INT_VECTOR && this.type != ArrayCacheType.INT_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        int[] nArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            this.isAllZero = this.isAllZero && e == 0;
            this.outStream.writeInt(e);
            ++n2;
        }
    }

    public void writeAsLong(int[] value) throws IOException {
        if (this.type != ArrayCacheType.LONG_VECTOR && this.type != ArrayCacheType.LONG_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        int[] nArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            this.isAllZero = this.isAllZero && e == 0;
            this.outStream.writeLong(e);
            ++n2;
        }
    }

    public void write(long[] value) throws IOException {
        if (this.type != ArrayCacheType.LONG_VECTOR && this.type != ArrayCacheType.LONG_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        long[] lArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            this.isAllZero = this.isAllZero && e == 0L;
            this.outStream.writeLong(e);
            ++n2;
        }
    }

    public double[] getDoubleArray() throws IOException {
        this.closeOut();
        this.openInput();
        if (this.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        double[] value = new double[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.inStream.readDouble();
            ++i;
        }
        this.closeInput();
        return value;
    }

    public double[][] getDoubleMatrix() throws IOException {
        this.closeOut();
        this.openInput();
        if (this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        if (this.dimensions.length != 1) {
            throw new RuntimeException("Wrong format of result data.");
        }
        double[][] value = new double[this.size / this.dimensions[0]][this.dimensions[0]];
        int i = 0;
        while (i < value.length) {
            int j = 0;
            while (j < value[0].length) {
                value[i][j] = this.inStream.readDouble();
                ++j;
            }
            ++i;
        }
        this.closeInput();
        return value;
    }

    public double[] getFloatArrayAsDouble() throws IOException {
        if (this.type != ArrayCacheType.FLOAT_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        double[] value = new double[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.inStream.readFloat();
            ++i;
        }
        this.closeInput();
        return value;
    }

    public int[] getIntArray() throws IOException {
        if (this.type != ArrayCacheType.INT_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        int[] value = new int[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.inStream.readInt();
            ++i;
        }
        this.closeInput();
        return value;
    }

    public double[] getIntAsDoubleArray() throws IOException {
        if (this.type != ArrayCacheType.INT_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        double[] value = new double[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.inStream.readInt();
            ++i;
        }
        this.closeInput();
        return value;
    }

    public float[] getDoubleAsFloatArray() throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        float[] value = new float[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = (float)this.inStream.readDouble();
            ++i;
        }
        this.closeInput();
        return value;
    }

    public long[] getLongArray() throws IOException {
        if (this.type != ArrayCacheType.LONG_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        long[] value = new long[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.inStream.readLong();
            ++i;
        }
        this.closeInput();
        return value;
    }

    public float[] getFloatArray() throws IOException {
        if (this.type == ArrayCacheType.DOUBLE_VECTOR) {
            return this.getDoubleAsFloatArray();
        }
        if (this.type != ArrayCacheType.FLOAT_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        float[] value = new float[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.inStream.readFloat();
            ++i;
        }
        this.closeInput();
        return value;
    }

    public static ArrayCache[] splitBatchDouble(ArrayCache value, int batchSize) throws IOException {
        int k;
        if (value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[batchSize];
        int i = 0;
        while (i < batchSize) {
            batchValue[i] = new ArrayCache(ArrayCacheType.DOUBLE_VECTOR);
            ++i;
        }
        int len = 0;
        value.openInput();
        while (len < value.size) {
            k = 0;
            while (k < batchSize) {
                double x = value.inStream.readDouble();
                batchValue[k].isAllZero = batchValue[k].isAllZero && x == 0.0;
                batchValue[k].outStream.writeDouble(x);
                ++batchValue[k].size;
                ++len;
                ++k;
            }
        }
        k = 0;
        while (k < batchSize) {
            batchValue[k].closeOut();
            ++k;
        }
        value.closeInput();
        return batchValue;
    }

    public static ArrayCache[] splitBatchDouble(ArrayCache value) throws IOException {
        int k;
        if (value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[value.dimensions.length];
        int i = 0;
        while (i < value.dimensions.length) {
            batchValue[i] = value.dimensions[i] == 1 ? new ArrayCache(ArrayCacheType.DOUBLE_VECTOR) : new ArrayCache(ArrayCacheType.DOUBLE_MATRIX);
            batchValue[i].setDimensions(new int[]{value.dimensions[i]});
            ++i;
        }
        int len = 0;
        value.openInput();
        while (len < value.size) {
            k = 0;
            while (k < value.dimensions.length) {
                int m = 0;
                while (m < value.dimensions[k]) {
                    double x = value.inStream.readDouble();
                    batchValue[k].isAllZero = batchValue[k].isAllZero && x == 0.0;
                    batchValue[k].outStream.writeDouble(x);
                    ++batchValue[k].size;
                    ++len;
                    ++m;
                }
                ++k;
            }
        }
        k = 0;
        while (k < value.dimensions.length) {
            batchValue[k].closeOut();
            ++k;
        }
        value.closeInput();
        return batchValue;
    }

    public static ArrayCache[] splitBatchDoubleToInt(ArrayCache value, int batchSize) throws IOException {
        int k;
        if (value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[batchSize];
        int i = 0;
        while (i < batchSize) {
            batchValue[i] = new ArrayCache(ArrayCacheType.INT_VECTOR);
            ++i;
        }
        int len = 0;
        value.openInput();
        while (len < value.size) {
            k = 0;
            while (k < batchSize) {
                int x = (int)value.inStream.readDouble();
                batchValue[k].isAllZero = batchValue[k].isAllZero && (double)x == 0.0;
                batchValue[k].outStream.writeInt(x);
                ++batchValue[k].size;
                ++len;
                ++k;
            }
        }
        k = 0;
        while (k < batchSize) {
            batchValue[k].closeOut();
            ++k;
        }
        value.closeInput();
        return batchValue;
    }

    public static ArrayCache copyArrayCacheLong(ArrayCache value) throws IOException {
        ArrayCache batchValue = new ArrayCache(value.type);
        value.openInput();
        int k = 0;
        while (k < value.size) {
            long x = value.inStream.readLong();
            batchValue.isAllZero = batchValue.isAllZero && (double)x == 0.0;
            batchValue.outStream.writeLong(x);
            ++batchValue.size;
            ++k;
        }
        batchValue.closeOut();
        value.closeInput();
        return batchValue;
    }

    protected void finalize() throws Throwable {
        if (this.outStream != null) {
            this.outStream.close();
        }
        if (this.inStream != null) {
            this.inStream.close();
        }
        this.outStream = null;
        this.inStream = null;
        this.file.delete();
        this.file = null;
        super.finalize();
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int[] dimensions) {
        if (dimensions != null) {
            this.dimensions = dimensions;
        }
        if (dimensions.length == 1 && dimensions[0] > 1) {
            this.type = ArrayCacheType.DOUBLE_MATRIX;
        }
    }

    public boolean isAllZero() {
        return this.isAllZero;
    }
}

