/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.math.BigDecimal;
import org.openfast.Global;
import org.openfast.NumericValue;
import org.openfast.error.FastConstants;
import org.openfast.template.LongValue;

public class IntegerValue
extends NumericValue {
    private static final long serialVersionUID = 1L;
    public final int value;

    public IntegerValue(int value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NumericValue)) {
            return false;
        }
        return this.equals((NumericValue)obj);
    }

    private boolean equals(NumericValue otherValue) {
        return (long)this.value == otherValue.toLong();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equalsValue(String defaultValue) {
        return Integer.parseInt(defaultValue) == this.value;
    }

    public NumericValue increment() {
        if (this.value == Integer.MAX_VALUE) {
            return new LongValue((long)this.value + 1L);
        }
        return new IntegerValue(this.value + 1);
    }

    public NumericValue decrement() {
        if (this.value == Integer.MIN_VALUE) {
            return new LongValue((long)this.value - 1L);
        }
        return new IntegerValue(this.value - 1);
    }

    public NumericValue subtract(NumericValue subend) {
        if (subend instanceof LongValue) {
            return new LongValue((long)this.value - subend.toLong());
        }
        return new IntegerValue(this.value - subend.toInt());
    }

    public NumericValue add(NumericValue addend) {
        long total = (long)this.value + addend.toLong();
        if (total <= Integer.MAX_VALUE && total >= Integer.MIN_VALUE) {
            return new IntegerValue((int)total);
        }
        return new LongValue(total);
    }

    public String serialize() {
        return String.valueOf(this.value);
    }

    public boolean equals(int value) {
        return value == this.value;
    }

    public long toLong() {
        return this.value;
    }

    public Object toObject() {
        return this.value;
    }

    public int toInt() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public byte toByte() {
        if (this.value > 127 || this.value < -128) {
            Global.handleError(FastConstants.R4_NUMERIC_VALUE_TOO_LARGE, "The value \"" + this.value + "\" is too large for a byte.");
        }
        return (byte)this.value;
    }

    public short toShort() {
        if (this.value > Short.MAX_VALUE || this.value < Short.MIN_VALUE) {
            Global.handleError(FastConstants.R4_NUMERIC_VALUE_TOO_LARGE, "The value \"" + this.value + "\" is too large for a short.");
        }
        return (short)this.value;
    }

    public double toDouble() {
        return this.value;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.value);
    }
}

