/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio.optimizer;

import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.optimizer.ForecastedValues;
import com.portfolioeffect.quant.client.portfolio.optimizer.PortfolioOptimizer;
import com.portfolioeffect.quant.client.result.MethodResult;
import com.portfolioeffect.quant.client.util.StreamQuantCallBackPureData;
import java.util.HashMap;

public class StrategyOptimizer
extends PortfolioOptimizer {
    private String forecasterType = "exp_smoothing";
    private String forecastPortfolioWindow = "";
    private String forecastExpWindow = "";
    private ForecastedValues forecastedValue = null;

    public StrategyOptimizer(Portfolio portfolio, double localOptimStopStep, double globalOptimProbability) {
        super(portfolio, localOptimStopStep, globalOptimProbability);
    }

    public StrategyOptimizer(Portfolio portfolio) {
        super(portfolio);
    }

    public void setForecastedValue(ForecastedValues forecastedValue) {
        this.forecastedValue = forecastedValue;
    }

    public ForecastedValues getForecastedValue() {
        return this.forecastedValue;
    }

    @Override
    public MethodResult getOptimizedPortfolio() throws Exception {
        MethodResult checkResult;
        this.optimizedPortfolio = new Portfolio(this.portfolio);
        this.resultPortfolio = new Portfolio(this.portfolio);
        try {
            HashMap<String, String> forecastParams = new HashMap<String, String>();
            forecastParams.put("section", "FORECAST_PARAMS");
            forecastParams.put("type", this.forecasterType);
            forecastParams.put("forecastPortfolioWindow", this.forecastPortfolioWindow);
            forecastParams.put("forecastExpWindow", this.forecastExpWindow);
            this.paramsBuffer.add(forecastParams);
            this.optimizationInit();
        }
        catch (Exception e1) {
            return new MethodResult(e1.getMessage());
        }
        if (this.forecastedValue != null && (checkResult = this.forecastedValue.addToPortfolio(this.optimizedPortfolio)).hasError()) {
            return new MethodResult(checkResult.getErrorMessage());
        }
        return this.makeOptimization();
    }

    @Override
    public MethodResult getOptimizedPortfolioStream() throws Exception {
        MethodResult checkResult;
        this.optimizedPortfolio = new Portfolio(this.portfolio);
        this.resultPortfolio = new Portfolio(this.portfolio);
        this.optimizedPortfolio.initStreamSingleMetric(new StreamQuantCallBackPureData(){

            @Override
            public void onDataRefresh(float[] data, long[] time) {
                int nSymbols = StrategyOptimizer.this.resultPortfolio.getSymbolNamesList().size();
                int len = 0;
                for (int i = 0; i < time.length; ++i) {
                    for (int k = 0; k < nSymbols; ++k) {
                        StrategyOptimizer.this.resultPortfolio.setStreamQuantity(StrategyOptimizer.this.resultPortfolio.getSymbolNamesList().get(k), (int)data[len], time[i]);
                        ++len;
                    }
                }
            }
        });
        try {
            HashMap<String, String> forecastParams = new HashMap<String, String>();
            forecastParams.put("section", "FORECAST_PARAMS");
            forecastParams.put("type", this.forecasterType);
            forecastParams.put("forecastPortfolioWindow", this.forecastPortfolioWindow);
            forecastParams.put("forecastExpWindow", this.forecastExpWindow);
            this.paramsBuffer.add(forecastParams);
            this.optimizationInit();
        }
        catch (Exception e1) {
            return new MethodResult(e1.getMessage());
        }
        if (this.forecastedValue != null && (checkResult = this.forecastedValue.addToPortfolio(this.optimizedPortfolio)).hasError()) {
            return new MethodResult(checkResult.getErrorMessage());
        }
        return this.makeOptimization();
    }

    public String getForecasterType() {
        return this.forecasterType;
    }

    public void setForecasterType(String forecasterType) {
        this.forecasterType = forecasterType;
    }

    public String getForecastPortfolioWindow() {
        return this.forecastPortfolioWindow;
    }

    public void setForecastPortfolioWindow(String forecastPortfolioWindow) {
        this.forecastPortfolioWindow = forecastPortfolioWindow;
    }

    public String getForecastExpWindow() {
        return this.forecastExpWindow;
    }

    public void setForecastExpWindow(String forecastExpWindow) {
        this.forecastExpWindow = forecastExpWindow;
    }
}

