/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openfast.BitVector;
import org.openfast.BitVectorBuilder;
import org.openfast.BitVectorReader;
import org.openfast.BitVectorValue;
import org.openfast.Context;
import org.openfast.FieldValue;
import org.openfast.Global;
import org.openfast.GroupValue;
import org.openfast.Node;
import org.openfast.QName;
import org.openfast.error.FastConstants;
import org.openfast.error.FastException;
import org.openfast.template.Field;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Scalar;
import org.openfast.template.Sequence;
import org.openfast.template.StaticTemplateReference;
import org.openfast.template.type.codec.TypeCodec;

public class Group
extends Field {
    private static final long serialVersionUID = 1L;
    private QName typeReference = null;
    protected String childNamespace = "";
    protected final Field[] fields;
    protected final Map fieldIndexMap;
    protected final Map fieldIdMap;
    protected final Map fieldNameMap;
    protected final boolean usesPresenceMap;
    protected final StaticTemplateReference[] staticTemplateReferences;
    protected final Field[] fieldDefinitions;
    protected final Map introspectiveFieldMap;

    public Group(String name, Field[] fields, boolean optional) {
        this(new QName(name), fields, optional);
    }

    public Group(QName name, Field[] fields, boolean optional) {
        super(name, optional);
        ArrayList<Field> expandedFields = new ArrayList<Field>();
        ArrayList<Field> staticTemplateReferences = new ArrayList<Field>();
        int i = 0;
        while (i < fields.length) {
            if (fields[i] instanceof StaticTemplateReference) {
                Field[] referenceFields = ((StaticTemplateReference)fields[i]).getTemplate().getFields();
                int j = 1;
                while (j < referenceFields.length) {
                    expandedFields.add(referenceFields[j]);
                    ++j;
                }
                staticTemplateReferences.add(fields[i]);
            } else {
                expandedFields.add(fields[i]);
            }
            ++i;
        }
        this.fields = expandedFields.toArray(new Field[expandedFields.size()]);
        this.fieldDefinitions = fields;
        this.fieldIndexMap = Group.constructFieldIndexMap(this.fields);
        this.fieldNameMap = Group.constructFieldNameMap(this.fields);
        this.fieldIdMap = Group.constructFieldIdMap(this.fields);
        this.introspectiveFieldMap = Group.constructInstrospectiveFields(this.fields);
        this.usesPresenceMap = Group.determinePresenceMapUsage(this.fields);
        this.staticTemplateReferences = staticTemplateReferences.toArray(new StaticTemplateReference[staticTemplateReferences.size()]);
    }

    private static Map constructInstrospectiveFields(Field[] fields) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        int i = 0;
        while (i < fields.length) {
            if (fields[i] instanceof Scalar && fields[i].hasChild(FastConstants.LENGTH_FIELD)) {
                Node lengthNode = (Node)fields[i].getChildren(FastConstants.LENGTH_FIELD).get(0);
                map.put(lengthNode.getAttribute(FastConstants.LENGTH_NAME_ATTR), fields[i]);
            }
            ++i;
        }
        if (map.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        return map;
    }

    private static boolean determinePresenceMapUsage(Field[] fields) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i].usesPresenceMapBit()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public byte[] encode(FieldValue value, Group template, Context context, BitVectorBuilder presenceMapBuilder) {
        byte[] encoding = this.encode(value, template, context);
        if (this.optional) {
            if (encoding.length != 0) {
                presenceMapBuilder.set();
            } else {
                presenceMapBuilder.skip();
            }
        }
        return encoding;
    }

    public byte[] encode(FieldValue value, Group template, Context context) {
        if (value == null) {
            return new byte[0];
        }
        GroupValue groupValue = (GroupValue)value;
        if (context.isTraceEnabled()) {
            context.getEncodeTrace().groupStart(this);
        }
        BitVectorBuilder presenceMapBuilder = new BitVectorBuilder(groupValue.getGroup().getMaxPresenceMapSize());
        try {
            byte[][] fieldEncodings = new byte[this.fields.length][];
            int fieldIndex = 0;
            while (fieldIndex < this.fields.length) {
                FieldValue fieldValue = groupValue.getValue(fieldIndex);
                Field field = this.getField(fieldIndex);
                if (!field.isOptional() && fieldValue == null) {
                    Global.handleError(FastConstants.GENERAL_ERROR, "Mandatory field " + field + " is null");
                }
                Group fieldTmpl = template;
                if (field.getTemplate() != null) {
                    fieldTmpl = field.getTemplate();
                }
                byte[] encoding = field.encode(fieldValue, fieldTmpl, context, presenceMapBuilder);
                fieldEncodings[fieldIndex] = encoding;
                ++fieldIndex;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            if (this.usesPresenceMap()) {
                byte[] pmap = presenceMapBuilder.getBitVector().getTruncatedBytes();
                if (context.isTraceEnabled()) {
                    context.getEncodeTrace().pmap(pmap);
                }
                buffer.write(pmap);
            }
            int i = 0;
            while (i < fieldEncodings.length) {
                if (fieldEncodings[i] != null) {
                    buffer.write(fieldEncodings[i]);
                }
                ++i;
            }
            if (context.isTraceEnabled()) {
                context.getEncodeTrace().groupEnd();
            }
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int getMaxPresenceMapSize() {
        return this.fields.length * 2;
    }

    public FieldValue decode(InputStream in, Group group, Context context, BitVectorReader pmapReader) {
        try {
            if (!this.usesPresenceMapBit() || pmapReader.read()) {
                if (context.isTraceEnabled()) {
                    context.getDecodeTrace().groupStart(this);
                }
                GroupValue groupValue = new GroupValue(this, this.decodeFieldValues(in, group, context));
                if (context.isTraceEnabled()) {
                    context.getDecodeTrace().groupEnd();
                }
                return groupValue;
            }
            return null;
        }
        catch (FastException e) {
            throw new FastException("Error occurred while decoding " + this, e.getCode(), e);
        }
    }

    protected FieldValue[] decodeFieldValues(InputStream in, Group template, Context context) {
        if (this.usesPresenceMap()) {
            BitVector pmap = ((BitVectorValue)TypeCodec.BIT_VECTOR.decode((InputStream)in)).value;
            if (context.isTraceEnabled()) {
                context.getDecodeTrace().pmap(pmap.getBytes());
            }
            if (pmap.isOverlong()) {
                Global.handleError(FastConstants.R7_PMAP_OVERLONG, "The presence map " + pmap + " for the group " + this + " is overlong.");
            }
            return this.decodeFieldValues(in, template, new BitVectorReader(pmap), context);
        }
        return this.decodeFieldValues(in, template, BitVectorReader.NULL, context);
    }

    public FieldValue[] decodeFieldValues(InputStream in, Group template, BitVectorReader pmapReader, Context context) {
        int start;
        FieldValue[] values = new FieldValue[this.fields.length];
        int fieldIndex = start = this instanceof MessageTemplate ? 1 : 0;
        while (fieldIndex < this.fields.length) {
            Field field = this.getField(fieldIndex);
            Group fieldTmpl = template;
            if (field.getTemplate() != null) {
                fieldTmpl = field.getTemplate();
            }
            values[fieldIndex] = field.decode(in, fieldTmpl, context, pmapReader);
            ++fieldIndex;
        }
        if (pmapReader.hasMoreBitsSet()) {
            Global.handleError(FastConstants.R8_PMAP_TOO_MANY_BITS, "The presence map " + pmapReader + " has too many bits for the group " + this);
        }
        return values;
    }

    public boolean isPresenceMapBitSet(byte[] encoding, FieldValue fieldValue) {
        return encoding.length != 0;
    }

    public boolean usesPresenceMapBit() {
        return this.optional;
    }

    public boolean usesPresenceMap() {
        return this.usesPresenceMap;
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public Field getField(int index) {
        return this.fields[index];
    }

    public Class getValueType() {
        return GroupValue.class;
    }

    public FieldValue createValue(String value) {
        return new GroupValue(this, new FieldValue[this.fields.length]);
    }

    public String getTypeName() {
        return "group";
    }

    public Field getField(String fieldName) {
        return (Field)this.fieldNameMap.get(new QName(fieldName, this.childNamespace));
    }

    public Field getField(QName name) {
        return (Field)this.fieldNameMap.get(name);
    }

    private static Map constructFieldNameMap(Field[] fields) {
        HashMap<QName, Field> map = new HashMap<QName, Field>();
        int i = 0;
        while (i < fields.length) {
            map.put(fields[i].getQName(), fields[i]);
            ++i;
        }
        return map;
    }

    private static Map constructFieldIdMap(Field[] fields) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        int i = 0;
        while (i < fields.length) {
            map.put(fields[i].getId(), fields[i]);
            ++i;
        }
        return map;
    }

    private static Map constructFieldIndexMap(Field[] fields) {
        HashMap<Field, Integer> map = new HashMap<Field, Integer>();
        int i = 0;
        while (i < fields.length) {
            map.put(fields[i], new Integer(i));
            ++i;
        }
        return map;
    }

    public int getFieldIndex(String fieldName) {
        return (Integer)this.fieldIndexMap.get(this.getField(fieldName));
    }

    public int getFieldIndex(Field field) {
        return (Integer)this.fieldIndexMap.get(field);
    }

    public Sequence getSequence(String fieldName) {
        return (Sequence)this.getField(fieldName);
    }

    public Scalar getScalar(String fieldName) {
        return (Scalar)this.getField(fieldName);
    }

    public Scalar getScalar(int index) {
        return (Scalar)this.getField(index);
    }

    public Group getGroup(String fieldName) {
        return (Group)this.getField(fieldName);
    }

    public boolean hasField(String fieldName) {
        return this.fieldNameMap.containsKey(new QName(fieldName, this.childNamespace));
    }

    public boolean hasField(QName fieldName) {
        return this.fieldNameMap.containsKey(fieldName);
    }

    public Field[] getFields() {
        return this.fields;
    }

    public void setTypeReference(QName typeReference) {
        this.typeReference = typeReference;
    }

    public QName getTypeReference() {
        return this.typeReference;
    }

    public boolean hasTypeReference() {
        return this.typeReference != null;
    }

    public String toString() {
        return this.name.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Group.hashCode(this.fields);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.typeReference == null ? 0 : this.typeReference.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        if (other.fields.length != this.fields.length) {
            return false;
        }
        if (!other.name.equals(this.name)) {
            return false;
        }
        int i = 0;
        while (i < this.fields.length) {
            if (!this.fields[i].equals(other.fields[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int hashCode(Object[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public boolean hasFieldWithId(String id) {
        return this.fieldIdMap.containsKey(id);
    }

    public Field getFieldById(String id) {
        return (Field)this.fieldIdMap.get(id);
    }

    public String getChildNamespace() {
        return this.childNamespace;
    }

    public void setChildNamespace(String childNamespace) {
        this.childNamespace = childNamespace;
    }

    public StaticTemplateReference[] getStaticTemplateReferences() {
        return this.staticTemplateReferences;
    }

    public StaticTemplateReference getStaticTemplateReference(String name) {
        return this.getStaticTemplateReference(new QName(name, this.name.getNamespace()));
    }

    public StaticTemplateReference getStaticTemplateReference(QName name) {
        int i = 0;
        while (i < this.staticTemplateReferences.length) {
            if (this.staticTemplateReferences[i].getQName().equals(name)) {
                return this.staticTemplateReferences[i];
            }
            ++i;
        }
        return null;
    }

    public Field[] getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public boolean hasIntrospectiveField(String fieldName) {
        return this.introspectiveFieldMap.containsKey(fieldName);
    }

    public Scalar getIntrospectiveField(String fieldName) {
        return (Scalar)this.introspectiveFieldMap.get(fieldName);
    }
}

