/*
 * Decompiled with CFR 0.152.
 */
package com.kamikaze.pfordelta;

public class Simple16WithHardCodes {
    private static final int S16_NUMSIZE = 16;
    private static final int S16_BITSSIZE = 28;
    private static final int[] S16_NUM = new int[]{28, 21, 21, 21, 14, 9, 8, 7, 6, 6, 5, 5, 4, 3, 2, 1};
    private static final int[][] S16_BITS = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {4, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 4, 4, 4, 4, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {5, 5, 5, 5, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {4, 4, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 6, 6, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {5, 5, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {10, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {14, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    public static final int s16Compress(int[] out, int outOffset, int[] in, int inOffset, int n, int blockSize, int oriBlockSize, int[] oriInputBlock) {
        for (int numIdx = 0; numIdx < 16; ++numIdx) {
            int j;
            out[outOffset] = numIdx << 28;
            if (S16_NUM[numIdx] > n) continue;
            int num = S16_NUM[numIdx];
            int bits = 0;
            for (j = 0; j < num && in[inOffset + j] < 1 << S16_BITS[numIdx][j]; ++j) {
                int n2 = outOffset;
                out[n2] = out[n2] | in[inOffset + j] << bits;
                bits += S16_BITS[numIdx][j];
            }
            if (j != num) continue;
            return num;
        }
        return -1;
    }

    protected static final int s16CompressBackup(int[] out, int outOffset, int[] in, int inOffset, int n, int blockSize, int oriBlockSize, int[] oriInputBlock) {
        for (int numIdx = 0; numIdx < 16; ++numIdx) {
            int j;
            out[outOffset] = numIdx << 28;
            int num = S16_NUM[numIdx] < n ? S16_NUM[numIdx] : n;
            int bits = 0;
            for (j = 0; j < num && in[inOffset + j] < 1 << S16_BITS[numIdx][j]; ++j) {
                int n2 = outOffset;
                out[n2] = out[n2] | in[inOffset + j] << bits;
                bits += S16_BITS[numIdx][j];
            }
            if (j != num) continue;
            return num;
        }
        return -1;
    }

    protected static final int s16Decompress(int[] out, int outOffset, int[] in, int inOffset, int n) {
        int j = 0;
        int bits = 0;
        int numIdx = in[inOffset] >>> 28;
        int num = S16_NUM[numIdx] < n ? S16_NUM[numIdx] : n;
        bits = 0;
        for (j = 0; j < num; ++j) {
            out[outOffset + j] = Simple16WithHardCodes.readBitsForS16(in, inOffset, bits, S16_BITS[numIdx][j]);
            bits += S16_BITS[numIdx][j];
        }
        return num;
    }

    protected static final int s16DecompressWithIntBufferBackup(int[] out, int outOffset, int value, int n) {
        int numIdx = value >>> 28;
        int num = S16_NUM[numIdx] < n ? S16_NUM[numIdx] : n;
        int shift = 0;
        for (int j = 0; j < num; ++j) {
            int s16Bits = S16_BITS[numIdx][j];
            out[outOffset++] = value >>> shift & -1 >>> 32 - s16Bits;
            shift += s16Bits;
        }
        return num;
    }

    protected static final int s16DecompressWithIntBuffer(int[] out, int outOffset, int value, int n) {
        int numIdx = value >>> 28;
        int num = S16_NUM[numIdx];
        int shift = 0;
        for (int j = 0; j < num; ++j) {
            int s16Bits = S16_BITS[numIdx][j];
            out[outOffset++] = value >>> shift & -1 >>> 32 - s16Bits;
            shift += s16Bits;
        }
        return num;
    }

    protected static final int s16DecompressWithIntBufferWithHardCodes(int[] out, int outOffset, int value, int n) {
        int numIdx = value >>> 28;
        return Simple16WithHardCodes.s16DecompressOneNumberWithHardCodes(out, outOffset, value, numIdx);
    }

    protected static final int s16DecompressWithIntBufferIntegrated(int[] out, int outOffset, int value, int n, int[] expPos, int oribits) {
        int shift = 0;
        int numIdx = value >>> 28;
        int num = S16_NUM[numIdx];
        for (int j = 0; j < num; ++j) {
            int s16Bits = S16_BITS[numIdx][j];
            int n2 = expPos[outOffset + j];
            out[n2] = out[n2] | (value >>> shift & -1 >>> 32 - s16Bits) << oribits;
            shift += s16Bits;
        }
        return num;
    }

    protected static final int s16DecompressWithIntBufferIntegrated2(int[] out, int outOffset, int value, int n, int[] expPos, int oribits) {
        int numIdx = value >>> 28;
        return Simple16WithHardCodes.s16DecompressOneNumberWithHardCodesIntegrated(out, outOffset, value, numIdx, oribits, expPos);
    }

    protected static final int s16DecompressWithIntBufferIntegratedBackup(int[] out, int outOffset, int value, int n, int[] expPos, int oribits) {
        int num;
        int j = 0;
        int shift = 0;
        int numIdx = value >>> 28;
        int n2 = num = S16_NUM[numIdx] < n ? S16_NUM[numIdx] : n;
        while (j < num) {
            int s16Bits = S16_BITS[numIdx][j];
            int n3 = expPos[outOffset];
            out[n3] = out[n3] | (value >>> shift & -1 >>> 32 - s16Bits) << oribits;
            shift += s16Bits;
            ++j;
            ++outOffset;
        }
        return num;
    }

    protected static int s16DecompressOneNumberWithHardCodes(int[] out, int outOffset, int value, int numIdx) {
        switch (numIdx) {
            case 0: {
                out[outOffset] = value & 1;
                out[outOffset + 1] = value >>> 1 & 1;
                out[outOffset + 2] = value >>> 2 & 1;
                out[outOffset + 3] = value >>> 3 & 1;
                out[outOffset + 4] = value >>> 4 & 1;
                out[outOffset + 5] = value >>> 5 & 1;
                out[outOffset + 6] = value >>> 6 & 1;
                out[outOffset + 7] = value >>> 7 & 1;
                out[outOffset + 8] = value >>> 8 & 1;
                out[outOffset + 9] = value >>> 9 & 1;
                out[outOffset + 10] = value >>> 10 & 1;
                out[outOffset + 11] = value >>> 11 & 1;
                out[outOffset + 12] = value >>> 12 & 1;
                out[outOffset + 13] = value >>> 13 & 1;
                out[outOffset + 14] = value >>> 14 & 1;
                out[outOffset + 15] = value >>> 15 & 1;
                out[outOffset + 16] = value >>> 16 & 1;
                out[outOffset + 17] = value >>> 17 & 1;
                out[outOffset + 18] = value >>> 18 & 1;
                out[outOffset + 19] = value >>> 19 & 1;
                out[outOffset + 20] = value >>> 20 & 1;
                out[outOffset + 21] = value >>> 21 & 1;
                out[outOffset + 22] = value >>> 22 & 1;
                out[outOffset + 23] = value >>> 23 & 1;
                out[outOffset + 24] = value >>> 24 & 1;
                out[outOffset + 25] = value >>> 25 & 1;
                out[outOffset + 26] = value >>> 26 & 1;
                out[outOffset + 27] = value >>> 27 & 1;
                return 28;
            }
            case 1: {
                out[outOffset] = value & 3;
                out[outOffset + 1] = value >>> 2 & 3;
                out[outOffset + 2] = value >>> 4 & 3;
                out[outOffset + 3] = value >>> 6 & 3;
                out[outOffset + 4] = value >>> 8 & 3;
                out[outOffset + 5] = value >>> 10 & 3;
                out[outOffset + 6] = value >>> 12 & 3;
                out[outOffset + 7] = value >>> 14 & 1;
                out[outOffset + 8] = value >>> 15 & 1;
                out[outOffset + 9] = value >>> 16 & 1;
                out[outOffset + 10] = value >>> 17 & 1;
                out[outOffset + 11] = value >>> 18 & 1;
                out[outOffset + 12] = value >>> 19 & 1;
                out[outOffset + 13] = value >>> 20 & 1;
                out[outOffset + 14] = value >>> 21 & 1;
                out[outOffset + 15] = value >>> 22 & 1;
                out[outOffset + 16] = value >>> 23 & 1;
                out[outOffset + 17] = value >>> 24 & 1;
                out[outOffset + 18] = value >>> 25 & 1;
                out[outOffset + 19] = value >>> 26 & 1;
                out[outOffset + 20] = value >>> 27 & 1;
                return 21;
            }
            case 2: {
                out[outOffset] = value & 1;
                out[outOffset + 1] = value >>> 1 & 1;
                out[outOffset + 2] = value >>> 2 & 1;
                out[outOffset + 3] = value >>> 3 & 1;
                out[outOffset + 4] = value >>> 4 & 1;
                out[outOffset + 5] = value >>> 5 & 1;
                out[outOffset + 6] = value >>> 6 & 1;
                out[outOffset + 7] = value >>> 7 & 3;
                out[outOffset + 8] = value >>> 9 & 3;
                out[outOffset + 9] = value >>> 11 & 3;
                out[outOffset + 10] = value >>> 13 & 3;
                out[outOffset + 11] = value >>> 15 & 3;
                out[outOffset + 12] = value >>> 17 & 3;
                out[outOffset + 13] = value >>> 19 & 3;
                out[outOffset + 14] = value >>> 21 & 1;
                out[outOffset + 15] = value >>> 22 & 1;
                out[outOffset + 16] = value >>> 23 & 1;
                out[outOffset + 17] = value >>> 24 & 1;
                out[outOffset + 18] = value >>> 25 & 1;
                out[outOffset + 19] = value >>> 26 & 1;
                out[outOffset + 20] = value >>> 27 & 1;
                return 21;
            }
            case 3: {
                out[outOffset] = value & 1;
                out[outOffset + 1] = value >>> 1 & 1;
                out[outOffset + 2] = value >>> 2 & 1;
                out[outOffset + 3] = value >>> 3 & 1;
                out[outOffset + 4] = value >>> 4 & 1;
                out[outOffset + 5] = value >>> 5 & 1;
                out[outOffset + 6] = value >>> 6 & 1;
                out[outOffset + 7] = value >>> 7 & 1;
                out[outOffset + 8] = value >>> 8 & 1;
                out[outOffset + 9] = value >>> 9 & 1;
                out[outOffset + 10] = value >>> 10 & 1;
                out[outOffset + 11] = value >>> 11 & 1;
                out[outOffset + 12] = value >>> 12 & 1;
                out[outOffset + 13] = value >>> 13 & 1;
                out[outOffset + 14] = value >>> 14 & 3;
                out[outOffset + 15] = value >>> 16 & 3;
                out[outOffset + 16] = value >>> 18 & 3;
                out[outOffset + 17] = value >>> 20 & 3;
                out[outOffset + 18] = value >>> 22 & 3;
                out[outOffset + 19] = value >>> 24 & 3;
                out[outOffset + 20] = value >>> 26 & 3;
                return 21;
            }
            case 4: {
                out[outOffset] = value & 3;
                out[outOffset + 1] = value >>> 2 & 3;
                out[outOffset + 2] = value >>> 4 & 3;
                out[outOffset + 3] = value >>> 6 & 3;
                out[outOffset + 4] = value >>> 8 & 3;
                out[outOffset + 5] = value >>> 10 & 3;
                out[outOffset + 6] = value >>> 12 & 3;
                out[outOffset + 7] = value >>> 14 & 3;
                out[outOffset + 8] = value >>> 16 & 3;
                out[outOffset + 9] = value >>> 18 & 3;
                out[outOffset + 10] = value >>> 20 & 3;
                out[outOffset + 11] = value >>> 22 & 3;
                out[outOffset + 12] = value >>> 24 & 3;
                out[outOffset + 13] = value >>> 26 & 3;
                return 14;
            }
            case 5: {
                out[outOffset] = value & 0xF;
                out[outOffset + 1] = value >>> 4 & 7;
                out[outOffset + 2] = value >>> 7 & 7;
                out[outOffset + 3] = value >>> 10 & 7;
                out[outOffset + 4] = value >>> 13 & 7;
                out[outOffset + 5] = value >>> 16 & 7;
                out[outOffset + 6] = value >>> 19 & 7;
                out[outOffset + 7] = value >>> 22 & 7;
                out[outOffset + 8] = value >>> 25 & 7;
                return 9;
            }
            case 6: {
                out[outOffset] = value & 7;
                out[outOffset + 1] = value >>> 3 & 0xF;
                out[outOffset + 2] = value >>> 7 & 0xF;
                out[outOffset + 3] = value >>> 11 & 0xF;
                out[outOffset + 4] = value >>> 15 & 0xF;
                out[outOffset + 5] = value >>> 19 & 7;
                out[outOffset + 6] = value >>> 22 & 7;
                out[outOffset + 7] = value >>> 25 & 7;
                return 8;
            }
            case 7: {
                out[outOffset] = value & 0xF;
                out[outOffset + 1] = value >>> 4 & 0xF;
                out[outOffset + 2] = value >>> 8 & 0xF;
                out[outOffset + 3] = value >>> 12 & 0xF;
                out[outOffset + 4] = value >>> 16 & 0xF;
                out[outOffset + 5] = value >>> 20 & 0xF;
                out[outOffset + 6] = value >>> 24 & 0xF;
                return 7;
            }
            case 8: {
                out[outOffset] = value & 0x1F;
                out[outOffset + 1] = value >>> 5 & 0x1F;
                out[outOffset + 2] = value >>> 10 & 0x1F;
                out[outOffset + 3] = value >>> 15 & 0x1F;
                out[outOffset + 4] = value >>> 20 & 0xF;
                out[outOffset + 5] = value >>> 24 & 0xF;
                return 6;
            }
            case 9: {
                out[outOffset] = value & 0xF;
                out[outOffset + 1] = value >>> 4 & 0xF;
                out[outOffset + 2] = value >>> 8 & 0x1F;
                out[outOffset + 3] = value >>> 13 & 0x1F;
                out[outOffset + 4] = value >>> 18 & 0x1F;
                out[outOffset + 5] = value >>> 23 & 0x1F;
                return 6;
            }
            case 10: {
                out[outOffset] = value & 0x3F;
                out[outOffset + 1] = value >>> 6 & 0x3F;
                out[outOffset + 2] = value >>> 12 & 0x3F;
                out[outOffset + 3] = value >>> 18 & 0x1F;
                out[outOffset + 4] = value >>> 23 & 0x1F;
                return 5;
            }
            case 11: {
                out[outOffset] = value & 0x1F;
                out[outOffset + 1] = value >>> 5 & 0x1F;
                out[outOffset + 2] = value >>> 10 & 0x3F;
                out[outOffset + 3] = value >>> 16 & 0x3F;
                out[outOffset + 4] = value >>> 22 & 0x3F;
                return 5;
            }
            case 12: {
                out[outOffset] = value & 0x7F;
                out[outOffset + 1] = value >>> 7 & 0x7F;
                out[outOffset + 2] = value >>> 14 & 0x7F;
                out[outOffset + 3] = value >>> 21 & 0x7F;
                return 4;
            }
            case 13: {
                out[outOffset] = value & 0x3FF;
                out[outOffset + 1] = value >>> 10 & 0x1FF;
                out[outOffset + 2] = value >>> 19 & 0x1FF;
                return 3;
            }
            case 14: {
                out[outOffset] = value & 0x3FFF;
                out[outOffset + 1] = value >>> 14 & 0x3FFF;
                return 2;
            }
            case 15: {
                out[outOffset] = value & 0xFFFFFFF;
                return 1;
            }
        }
        return -1;
    }

    protected static int s16DecompressOneNumberWithHardCodesIntegrated(int[] out, int outOffset, int value, int numIdx, int oribits, int[] expPos) {
        switch (numIdx) {
            case 0: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 1) << oribits;
                int n2 = expPos[outOffset + 1];
                out[n2] = out[n2] | (value >>> 1 & 1) << oribits;
                int n3 = expPos[outOffset + 2];
                out[n3] = out[n3] | (value >>> 2 & 1) << oribits;
                int n4 = expPos[outOffset + 3];
                out[n4] = out[n4] | (value >>> 3 & 1) << oribits;
                int n5 = expPos[outOffset + 4];
                out[n5] = out[n5] | (value >>> 4 & 1) << oribits;
                int n6 = expPos[outOffset + 5];
                out[n6] = out[n6] | (value >>> 5 & 1) << oribits;
                int n7 = expPos[outOffset + 6];
                out[n7] = out[n7] | (value >>> 6 & 1) << oribits;
                int n8 = expPos[outOffset + 7];
                out[n8] = out[n8] | (value >>> 7 & 1) << oribits;
                int n9 = expPos[outOffset + 8];
                out[n9] = out[n9] | (value >>> 8 & 1) << oribits;
                int n10 = expPos[outOffset + 9];
                out[n10] = out[n10] | (value >>> 9 & 1) << oribits;
                int n11 = expPos[outOffset + 10];
                out[n11] = out[n11] | (value >>> 10 & 1) << oribits;
                int n12 = expPos[outOffset + 11];
                out[n12] = out[n12] | (value >>> 11 & 1) << oribits;
                int n13 = expPos[outOffset + 12];
                out[n13] = out[n13] | (value >>> 12 & 1) << oribits;
                int n14 = expPos[outOffset + 13];
                out[n14] = out[n14] | (value >>> 13 & 1) << oribits;
                int n15 = expPos[outOffset + 14];
                out[n15] = out[n15] | (value >>> 14 & 1) << oribits;
                int n16 = expPos[outOffset + 15];
                out[n16] = out[n16] | (value >>> 15 & 1) << oribits;
                int n17 = expPos[outOffset + 16];
                out[n17] = out[n17] | (value >>> 16 & 1) << oribits;
                int n18 = expPos[outOffset + 17];
                out[n18] = out[n18] | (value >>> 17 & 1) << oribits;
                int n19 = expPos[outOffset + 18];
                out[n19] = out[n19] | (value >>> 18 & 1) << oribits;
                int n20 = expPos[outOffset + 19];
                out[n20] = out[n20] | (value >>> 19 & 1) << oribits;
                int n21 = expPos[outOffset + 20];
                out[n21] = out[n21] | (value >>> 20 & 1) << oribits;
                int n22 = expPos[outOffset + 21];
                out[n22] = out[n22] | (value >>> 21 & 1) << oribits;
                int n23 = expPos[outOffset + 22];
                out[n23] = out[n23] | (value >>> 22 & 1) << oribits;
                int n24 = expPos[outOffset + 23];
                out[n24] = out[n24] | (value >>> 23 & 1) << oribits;
                int n25 = expPos[outOffset + 24];
                out[n25] = out[n25] | (value >>> 24 & 1) << oribits;
                int n26 = expPos[outOffset + 25];
                out[n26] = out[n26] | (value >>> 25 & 1) << oribits;
                int n27 = expPos[outOffset + 26];
                out[n27] = out[n27] | (value >>> 26 & 1) << oribits;
                int n28 = expPos[outOffset + 27];
                out[n28] = out[n28] | (value >>> 27 & 1) << oribits;
                return 28;
            }
            case 1: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 3) << oribits;
                int n29 = expPos[outOffset + 1];
                out[n29] = out[n29] | (value >>> 2 & 3) << oribits;
                int n30 = expPos[outOffset + 2];
                out[n30] = out[n30] | (value >>> 4 & 3) << oribits;
                int n31 = expPos[outOffset + 3];
                out[n31] = out[n31] | (value >>> 6 & 3) << oribits;
                int n32 = expPos[outOffset + 4];
                out[n32] = out[n32] | (value >>> 8 & 3) << oribits;
                int n33 = expPos[outOffset + 5];
                out[n33] = out[n33] | (value >>> 10 & 3) << oribits;
                int n34 = expPos[outOffset + 6];
                out[n34] = out[n34] | (value >>> 12 & 3) << oribits;
                int n35 = expPos[outOffset + 7];
                out[n35] = out[n35] | (value >>> 14 & 1) << oribits;
                int n36 = expPos[outOffset + 8];
                out[n36] = out[n36] | (value >>> 15 & 1) << oribits;
                int n37 = expPos[outOffset + 9];
                out[n37] = out[n37] | (value >>> 16 & 1) << oribits;
                int n38 = expPos[outOffset + 10];
                out[n38] = out[n38] | (value >>> 17 & 1) << oribits;
                int n39 = expPos[outOffset + 11];
                out[n39] = out[n39] | (value >>> 18 & 1) << oribits;
                int n40 = expPos[outOffset + 12];
                out[n40] = out[n40] | (value >>> 19 & 1) << oribits;
                int n41 = expPos[outOffset + 13];
                out[n41] = out[n41] | (value >>> 20 & 1) << oribits;
                int n42 = expPos[outOffset + 14];
                out[n42] = out[n42] | (value >>> 21 & 1) << oribits;
                int n43 = expPos[outOffset + 15];
                out[n43] = out[n43] | (value >>> 22 & 1) << oribits;
                int n44 = expPos[outOffset + 16];
                out[n44] = out[n44] | (value >>> 23 & 1) << oribits;
                int n45 = expPos[outOffset + 17];
                out[n45] = out[n45] | (value >>> 24 & 1) << oribits;
                int n46 = expPos[outOffset + 18];
                out[n46] = out[n46] | (value >>> 25 & 1) << oribits;
                int n47 = expPos[outOffset + 19];
                out[n47] = out[n47] | (value >>> 26 & 1) << oribits;
                int n48 = expPos[outOffset + 20];
                out[n48] = out[n48] | (value >>> 27 & 1) << oribits;
                return 21;
            }
            case 2: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 1) << oribits;
                int n49 = expPos[outOffset + 1];
                out[n49] = out[n49] | (value >>> 1 & 1) << oribits;
                int n50 = expPos[outOffset + 2];
                out[n50] = out[n50] | (value >>> 2 & 1) << oribits;
                int n51 = expPos[outOffset + 3];
                out[n51] = out[n51] | (value >>> 3 & 1) << oribits;
                int n52 = expPos[outOffset + 4];
                out[n52] = out[n52] | (value >>> 4 & 1) << oribits;
                int n53 = expPos[outOffset + 5];
                out[n53] = out[n53] | (value >>> 5 & 1) << oribits;
                int n54 = expPos[outOffset + 6];
                out[n54] = out[n54] | (value >>> 6 & 1) << oribits;
                int n55 = expPos[outOffset + 7];
                out[n55] = out[n55] | (value >>> 7 & 3) << oribits;
                int n56 = expPos[outOffset + 8];
                out[n56] = out[n56] | (value >>> 9 & 3) << oribits;
                int n57 = expPos[outOffset + 9];
                out[n57] = out[n57] | (value >>> 11 & 3) << oribits;
                int n58 = expPos[outOffset + 10];
                out[n58] = out[n58] | (value >>> 13 & 3) << oribits;
                int n59 = expPos[outOffset + 11];
                out[n59] = out[n59] | (value >>> 15 & 3) << oribits;
                int n60 = expPos[outOffset + 12];
                out[n60] = out[n60] | (value >>> 17 & 3) << oribits;
                int n61 = expPos[outOffset + 13];
                out[n61] = out[n61] | (value >>> 19 & 3) << oribits;
                int n62 = expPos[outOffset + 14];
                out[n62] = out[n62] | (value >>> 21 & 1) << oribits;
                int n63 = expPos[outOffset + 15];
                out[n63] = out[n63] | (value >>> 22 & 1) << oribits;
                int n64 = expPos[outOffset + 16];
                out[n64] = out[n64] | (value >>> 23 & 1) << oribits;
                int n65 = expPos[outOffset + 17];
                out[n65] = out[n65] | (value >>> 24 & 1) << oribits;
                int n66 = expPos[outOffset + 18];
                out[n66] = out[n66] | (value >>> 25 & 1) << oribits;
                int n67 = expPos[outOffset + 19];
                out[n67] = out[n67] | (value >>> 26 & 1) << oribits;
                int n68 = expPos[outOffset + 20];
                out[n68] = out[n68] | (value >>> 27 & 1) << oribits;
                return 21;
            }
            case 3: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 1) << oribits;
                int n69 = expPos[outOffset + 1];
                out[n69] = out[n69] | (value >>> 1 & 1) << oribits;
                int n70 = expPos[outOffset + 2];
                out[n70] = out[n70] | (value >>> 2 & 1) << oribits;
                int n71 = expPos[outOffset + 3];
                out[n71] = out[n71] | (value >>> 3 & 1) << oribits;
                int n72 = expPos[outOffset + 4];
                out[n72] = out[n72] | (value >>> 4 & 1) << oribits;
                int n73 = expPos[outOffset + 5];
                out[n73] = out[n73] | (value >>> 5 & 1) << oribits;
                int n74 = expPos[outOffset + 6];
                out[n74] = out[n74] | (value >>> 6 & 1) << oribits;
                int n75 = expPos[outOffset + 7];
                out[n75] = out[n75] | (value >>> 7 & 1) << oribits;
                int n76 = expPos[outOffset + 8];
                out[n76] = out[n76] | (value >>> 8 & 1) << oribits;
                int n77 = expPos[outOffset + 9];
                out[n77] = out[n77] | (value >>> 9 & 1) << oribits;
                int n78 = expPos[outOffset + 10];
                out[n78] = out[n78] | (value >>> 10 & 1) << oribits;
                int n79 = expPos[outOffset + 11];
                out[n79] = out[n79] | (value >>> 11 & 1) << oribits;
                int n80 = expPos[outOffset + 12];
                out[n80] = out[n80] | (value >>> 12 & 1) << oribits;
                int n81 = expPos[outOffset + 13];
                out[n81] = out[n81] | (value >>> 13 & 1) << oribits;
                int n82 = expPos[outOffset + 14];
                out[n82] = out[n82] | (value >>> 14 & 3) << oribits;
                int n83 = expPos[outOffset + 15];
                out[n83] = out[n83] | (value >>> 16 & 3) << oribits;
                int n84 = expPos[outOffset + 16];
                out[n84] = out[n84] | (value >>> 18 & 3) << oribits;
                int n85 = expPos[outOffset + 17];
                out[n85] = out[n85] | (value >>> 20 & 3) << oribits;
                int n86 = expPos[outOffset + 18];
                out[n86] = out[n86] | (value >>> 22 & 3) << oribits;
                int n87 = expPos[outOffset + 19];
                out[n87] = out[n87] | (value >>> 24 & 3) << oribits;
                int n88 = expPos[outOffset + 20];
                out[n88] = out[n88] | (value >>> 26 & 3) << oribits;
                return 21;
            }
            case 4: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 3) << oribits;
                int n89 = expPos[outOffset + 1];
                out[n89] = out[n89] | (value >>> 2 & 3) << oribits;
                int n90 = expPos[outOffset + 2];
                out[n90] = out[n90] | (value >>> 4 & 3) << oribits;
                int n91 = expPos[outOffset + 3];
                out[n91] = out[n91] | (value >>> 6 & 3) << oribits;
                int n92 = expPos[outOffset + 4];
                out[n92] = out[n92] | (value >>> 8 & 3) << oribits;
                int n93 = expPos[outOffset + 5];
                out[n93] = out[n93] | (value >>> 10 & 3) << oribits;
                int n94 = expPos[outOffset + 6];
                out[n94] = out[n94] | (value >>> 12 & 3) << oribits;
                int n95 = expPos[outOffset + 7];
                out[n95] = out[n95] | (value >>> 14 & 3) << oribits;
                int n96 = expPos[outOffset + 8];
                out[n96] = out[n96] | (value >>> 16 & 3) << oribits;
                int n97 = expPos[outOffset + 9];
                out[n97] = out[n97] | (value >>> 18 & 3) << oribits;
                int n98 = expPos[outOffset + 10];
                out[n98] = out[n98] | (value >>> 20 & 3) << oribits;
                int n99 = expPos[outOffset + 11];
                out[n99] = out[n99] | (value >>> 22 & 3) << oribits;
                int n100 = expPos[outOffset + 12];
                out[n100] = out[n100] | (value >>> 24 & 3) << oribits;
                int n101 = expPos[outOffset + 13];
                out[n101] = out[n101] | (value >>> 26 & 3) << oribits;
                return 14;
            }
            case 5: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0xF) << oribits;
                int n102 = expPos[outOffset + 1];
                out[n102] = out[n102] | (value >>> 4 & 7) << oribits;
                int n103 = expPos[outOffset + 2];
                out[n103] = out[n103] | (value >>> 7 & 7) << oribits;
                int n104 = expPos[outOffset + 3];
                out[n104] = out[n104] | (value >>> 10 & 7) << oribits;
                int n105 = expPos[outOffset + 4];
                out[n105] = out[n105] | (value >>> 13 & 7) << oribits;
                int n106 = expPos[outOffset + 5];
                out[n106] = out[n106] | (value >>> 16 & 7) << oribits;
                int n107 = expPos[outOffset + 6];
                out[n107] = out[n107] | (value >>> 19 & 7) << oribits;
                int n108 = expPos[outOffset + 7];
                out[n108] = out[n108] | (value >>> 22 & 7) << oribits;
                int n109 = expPos[outOffset + 8];
                out[n109] = out[n109] | (value >>> 25 & 7) << oribits;
                return 9;
            }
            case 6: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 7) << oribits;
                int n110 = expPos[outOffset + 1];
                out[n110] = out[n110] | (value >>> 3 & 0xF) << oribits;
                int n111 = expPos[outOffset + 2];
                out[n111] = out[n111] | (value >>> 7 & 0xF) << oribits;
                int n112 = expPos[outOffset + 3];
                out[n112] = out[n112] | (value >>> 11 & 0xF) << oribits;
                int n113 = expPos[outOffset + 4];
                out[n113] = out[n113] | (value >>> 15 & 0xF) << oribits;
                int n114 = expPos[outOffset + 5];
                out[n114] = out[n114] | (value >>> 19 & 7) << oribits;
                int n115 = expPos[outOffset + 6];
                out[n115] = out[n115] | (value >>> 22 & 7) << oribits;
                int n116 = expPos[outOffset + 7];
                out[n116] = out[n116] | (value >>> 25 & 7) << oribits;
                return 8;
            }
            case 7: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0xF) << oribits;
                int n117 = expPos[outOffset + 1];
                out[n117] = out[n117] | (value >>> 4 & 0xF) << oribits;
                int n118 = expPos[outOffset + 2];
                out[n118] = out[n118] | (value >>> 8 & 0xF) << oribits;
                int n119 = expPos[outOffset + 3];
                out[n119] = out[n119] | (value >>> 12 & 0xF) << oribits;
                int n120 = expPos[outOffset + 4];
                out[n120] = out[n120] | (value >>> 16 & 0xF) << oribits;
                int n121 = expPos[outOffset + 5];
                out[n121] = out[n121] | (value >>> 20 & 0xF) << oribits;
                int n122 = expPos[outOffset + 6];
                out[n122] = out[n122] | (value >>> 24 & 0xF) << oribits;
                return 7;
            }
            case 8: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0x1F) << oribits;
                int n123 = expPos[outOffset + 1];
                out[n123] = out[n123] | (value >>> 5 & 0x1F) << oribits;
                int n124 = expPos[outOffset + 2];
                out[n124] = out[n124] | (value >>> 10 & 0x1F) << oribits;
                int n125 = expPos[outOffset + 3];
                out[n125] = out[n125] | (value >>> 15 & 0x1F) << oribits;
                int n126 = expPos[outOffset + 4];
                out[n126] = out[n126] | (value >>> 20 & 0xF) << oribits;
                int n127 = expPos[outOffset + 5];
                out[n127] = out[n127] | (value >>> 24 & 0xF) << oribits;
                return 6;
            }
            case 9: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0xF) << oribits;
                int n128 = expPos[outOffset + 1];
                out[n128] = out[n128] | (value >>> 4 & 0xF) << oribits;
                int n129 = expPos[outOffset + 2];
                out[n129] = out[n129] | (value >>> 8 & 0x1F) << oribits;
                int n130 = expPos[outOffset + 3];
                out[n130] = out[n130] | (value >>> 13 & 0x1F) << oribits;
                int n131 = expPos[outOffset + 4];
                out[n131] = out[n131] | (value >>> 18 & 0x1F) << oribits;
                int n132 = expPos[outOffset + 5];
                out[n132] = out[n132] | (value >>> 23 & 0x1F) << oribits;
                return 6;
            }
            case 10: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0x3F) << oribits;
                int n133 = expPos[outOffset + 1];
                out[n133] = out[n133] | (value >>> 6 & 0x3F) << oribits;
                int n134 = expPos[outOffset + 2];
                out[n134] = out[n134] | (value >>> 12 & 0x3F) << oribits;
                int n135 = expPos[outOffset + 3];
                out[n135] = out[n135] | (value >>> 18 & 0x1F) << oribits;
                int n136 = expPos[outOffset + 4];
                out[n136] = out[n136] | (value >>> 23 & 0x1F) << oribits;
                return 5;
            }
            case 11: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0x1F) << oribits;
                int n137 = expPos[outOffset + 1];
                out[n137] = out[n137] | (value >>> 5 & 0x1F) << oribits;
                int n138 = expPos[outOffset + 2];
                out[n138] = out[n138] | (value >>> 10 & 0x3F) << oribits;
                int n139 = expPos[outOffset + 3];
                out[n139] = out[n139] | (value >>> 16 & 0x3F) << oribits;
                int n140 = expPos[outOffset + 4];
                out[n140] = out[n140] | (value >>> 22 & 0x3F) << oribits;
                return 5;
            }
            case 12: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0x7F) << oribits;
                int n141 = expPos[outOffset + 1];
                out[n141] = out[n141] | (value >>> 7 & 0x7F) << oribits;
                int n142 = expPos[outOffset + 2];
                out[n142] = out[n142] | (value >>> 14 & 0x7F) << oribits;
                int n143 = expPos[outOffset + 3];
                out[n143] = out[n143] | (value >>> 21 & 0x7F) << oribits;
                return 4;
            }
            case 13: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0x3FF) << oribits;
                int n144 = expPos[outOffset + 1];
                out[n144] = out[n144] | (value >>> 10 & 0x1FF) << oribits;
                int n145 = expPos[outOffset + 2];
                out[n145] = out[n145] | (value >>> 19 & 0x1FF) << oribits;
                return 3;
            }
            case 14: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0x3FFF) << oribits;
                int n146 = expPos[outOffset + 1];
                out[n146] = out[n146] | (value >>> 14 & 0x3FFF) << oribits;
                return 2;
            }
            case 15: {
                int n = expPos[outOffset];
                out[n] = out[n] | (value & 0xFFFFFFF) << oribits;
                return 1;
            }
        }
        return -1;
    }

    private static int readBitsForS16(int[] in, int inIntOffset, int inWithIntOffset, int bits) {
        int val = in[inIntOffset] >>> inWithIntOffset;
        return val & -1 >>> 32 - bits;
    }
}

