% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sums.R
\name{pairwiseSum}
\alias{pairwiseSum}
\title{Return an accurate floating point sum of values}
\usage{
pairwiseSum(numbers)
}
\arguments{
\item{numbers}{A vector of numbers to sum.}
}
\value{
A sum of numbers with a rounding error of O(lg n) instead
    of O(n).
}
\description{
This was taken by NumPy and adapted for use here.  It is more
accurate than a standard sum, but still has numerical issues.  Its
main benefit is that it is about the same amount of time as a
standard time with the added accuracy.
}
\references{
\url{https://github.com/juliantaylor/numpy/blob/b0bc01275cac04483e6df021211c1fa2ba65eaa3/numpy/core/src/umath/loops.c.src}

\url{https://github.com/numpy/numpy/pull/3685}
}
\author{
Matthew Fidler (R implementation), Julian Taylor, Nathaniel
    J Smith, and  NumPy team.
#' @examples
sum(c(1,1e100,1,-1e100)) ## Should be 2, gives 0
pairwiseSum(c(1,1e100,1,-1e100)) ## Should be 2, still 0
}
