% Generated by roxygen2 (4.0.2): do not edit by hand
\name{spatial.pred.binomial.Bayes}
\alias{spatial.pred.binomial.Bayes}
\title{Bayesian spatial prediction for the binomial logistic and binary probit models}
\usage{
spatial.pred.binomial.Bayes(object, grid.pred, predictors = NULL,
  type = "marginal", scale.predictions = "prevalence",
  quantiles = c(0.025, 0.975), standard.errors = FALSE, thresholds = NULL,
  scale.thresholds = NULL, messages = TRUE)
}
\arguments{
\item{object}{an object of class "Bayes.PrevMap" obtained as result of a call to \code{\link{binomial.logistic.Bayes}} or \code{\link{binary.probit.Bayes}}.}

\item{grid.pred}{a matrix of prediction locations.}

\item{predictors}{a data frame of the values of the explanatory variables at each of the locations in \code{grid.pred}; each column correspond to a variable and each row to a location. \bold{Warning:} the names of the columns in the data frame must match those in the data used to fit the model. Default is \code{predictors=NULL} for models with only an intercept.}

\item{type}{a character indicating the type of spatial predictions: \code{type="marginal"} for marginal predictions or \code{type="joint"} for joint predictions. Default is \code{type="marginal"}. In the case of a low-rank approximation only joint predictions are available.}

\item{scale.predictions}{a character vector of maximum length 3, indicating the required scale on which spatial prediction is carried out: "logit", "prevalence", "odds" and "probit". Default is \code{scale.predictions="prevalence"}.}

\item{quantiles}{a vector of quantiles used to summarise the spatial predictions.}

\item{standard.errors}{logical; if \code{standard.errors=TRUE}, then standard errors for each \code{scale.predictions} are returned. Default is \code{standard.errors=FALSE}.}

\item{thresholds}{a vector of exceedance thresholds; default is \code{NULL}.}

\item{scale.thresholds}{a character value ("logit", "prevalence", "odds" or "probit") indicating the scale on which exceedance thresholds are provided.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}
}
\value{
A "pred.PrevMap" object list with the following components: \code{logit}; \code{prevalence}; \code{odds}; \code{probit};\code{exceedance.prob}, corresponding to a matrix of the exceedance probabilities where each column corresponds to a specified value in \code{thresholds}; \code{samples}, corresponding to a matrix of the posterior samples at each prediction locations for the linear predictor; \code{grid.pred} prediction locations.
Each of the three components \code{logit}, \code{prevalence},  \code{odds} and \code{probit} is also a list with the following components:

\code{predictions}: a vector of the predictive mean for the associated quantity (logit, odds or prevalence).

\code{standard.errors}: a vector of prediction standard errors (if \code{standard.errors=TRUE}).

\code{quantiles}: a matrix of quantiles of the resulting predictions with each column corresponding to a quantile specified through the argument \code{quantiles}.
}
\description{
This function performs Bayesian spatial prediction for the binomial logistic and binary probit models.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

