% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_Machine_Learning.R
\name{load_model}
\alias{load_model}
\title{Loading the machine learning model from the disk}
\usage{
load_model(dir = "ML_model")
}
\arguments{
\item{dir}{The name of the directory from which the machine learning model is to be loaded. The directory must be in the working directory.}
}
\value{
This function loads a list of ML model elements from the disk, i.e. the needed 8 files are read from the directory selected by \code{dir}. After loading the model it can be used for product classification by using \code{data_classifying} function.
}
\description{
This function loads a list of machine learning model elements from the disk, i.e. the needed 8 files are read.
}
\examples{
#Setting a temporal directory as a working directory
\dontrun{wd<-tempdir()}
\dontrun{setwd(wd)}
#Building the model
\donttest{my.grid=list(eta=c(0.01,0.02,0.05),subsample=c(0.5,0.8))}
\donttest{data_train<-dplyr::filter(dataCOICOP,dataCOICOP$time<=as.Date("2021-10-01"))}
\donttest{data_test<-dplyr::filter(dataCOICOP,dataCOICOP$time==as.Date("2021-11-01"))}
\donttest{ML<-model_classification(data_train,data_test,coicop="coicop6",grid=my.grid,
indicators=c("description","codeIN"),key_words=c("uht"),rounds=60)}
#Saving the model
\dontrun{save_model(ML, dir="My_model")}
#Loading the model
\dontrun{ML_fromPC<-load_model("My_model")}
#COICOP predicting
\dontrun{data_classifying(ML_fromPC, data_test)}
}
