% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotData.R
\name{plotData}
\alias{plotData}
\title{A function to plot data}
\usage{
plotData(
  dataset,
  site,
  location = NULL,
  forcingDataset = NULL,
  forcingCondition = NULL,
  species = NULL,
  variables = NULL,
  period = NULL,
  aggregated = NULL,
  FUN = mean,
  automaticPanels = T,
  quality = NULL,
  decreasing = TRUE
)
}
\arguments{
\item{dataset}{a character string providing the name of a dataset}

\item{site}{a character string providing the name of a site.}

\item{location}{deprecated argument. Please use site instead.}

\item{forcingDataset}{a character string providing the name of a forcingDataset.
Only relevant for ISIMIP datasets.}

\item{forcingCondition}{a character string providing the name of a forcingCondition.
Only relevant for ISIMIP datasets.}

\item{species}{a character string providing the species name or species id.}

\item{variables}{a character array holding the variables to be plotted. Default  is all variables.}

\item{period}{a character array with either start or start and end of the subset.
It must have the format "YYYY-MM-DD", or c("YYYY-MM-DD", "YYYY-MM-DD").}

\item{aggregated}{a boolean indicating whether data should be aggregated for display.
Possible values are date, day, month and year.}

\item{FUN}{a function to use for aggregating the data}

\item{automaticPanels}{a boolean indicating whether the function automatically creates panels}

\item{quality}{a number indicating the quality threshold to be used. Default is none.}

\item{decreasing}{a boolean indicating whether the quality threshold should be applied up- or downwards}
}
\value{
plots for the specified dataset, site and variables
}
\description{
A function to plot data of a site
from the PROFOUND database.
}
\details{
Plotting is not supported for the following datasets: OVERVIEW, SITES, SOIL(more). The aggregation of data
relies on the function \code{\link{aggregate}} for \code{\link{zoo}} objects. The FUN parameter
is passed to FUN from \code{\link{aggregate}}. Please check the help files of  \code{\link{aggregate}}
for further information. For handling NAs we recommend to pass self-defined functions (see examples).
}
\note{
To report errors in the package or the data, please use the issue tracker
in the GitHub repository of ProfoundData \url{https://github.com/COST-FP1304-PROFOUND/ProfoundData}
}
\examples{
# example requires that a sql DB is registered via setDB(dbfile)
# when run without a registered DB, you will get a file query (depending on OS)

\dontrun{
# Normal plotting
plotData(dataset = "CLIMATE_LOCAL", site = "le_bray", automaticPanels = TRUE)
plotData(dataset = "TREE", site = "solling_beech",   automaticPanels = TRUE)
plotData(dataset = "CLIMATE_LOCAL", site = "le_bray", automaticPanels = FALSE)
plotData(dataset = "TREE", site = "solling_beech",   automaticPanels = FALSE)

# Plot specific forcing datasets and conditions
plotData(dataset ="CLIMATE_ISIMIP2B", site ="soro", forcingDataset="GFDLESM2M",
         forcingCondition ="rcp2p6", automaticPanels = TRUE)

# Plot specific variables
plotData(dataset ="CLIMATE_ISIMIP2B",site ="soro", forcingDataset="GFDLESM2M",
         forcingCondition ="rcp2p6", variables = "p_mm")
plotData(dataset ="TREE",site ="solling_beech", variables = "dbh1_cm")

# Plot specific species
plotData(dataset ="TREE", site ="hyytiala", species = "Pinus sylvestris",
         automaticPanels = TRUE)

# Plot specific period
plotData(dataset = "CLIMATE_LOCAL", site =  "soro",
         period = c("2011-01-01","2012-12-31"))

# Set quality threshold
plotData(dataset = "CLIMATE_LOCAL", site = "soro",
         period = c("2011-01-01","2012-12-31"), quality = 1, decreasing = FALSE)
plotData(dataset = "FLUX", site = "soro", period = c("2011-01-01","2012-12-31"),
         quality = 0, decreasing = TRUE)

# Plot aggregated data
plotData(dataset = "CLIMATE_ISIMIP2B", site ="soro",  forcingDataset= "GFDLESM2M",
         forcingCondition="rcp2p6", variables = "tmax_degC",
         period = c("2020-01-01", "2022-01-01"),
         aggregate = "month", FUN =median)
plotData(dataset = "CLIMATE_ISIMIP2B", site ="soro",  forcingDataset= "GFDLESM2M",
         forcingCondition="rcp2p6", variables = "p_mm",
         period = c("2020-01-01", "2022-01-01"),
         aggregate = "month", FUN =sum)

# Plot aggregated data with self-defined function. In this case, compare month
# mean temperature of one year to mean of all period
data <- getData(dataset = "CLIMATE_ISIMIP2B", site ="soro",  forcingDataset= "GFDLESM2M",
                forcingCondition="rcp2p6", variables = "tmax_degC")
meanTemperature <- mean(data$tmax_degC, na.rm = TRUE)
difference <- function(x) {mean(x, na.rm = TRUE) -meanTemperature}

plotData(dataset = "CLIMATE_ISIMIP2B", site ="soro",  forcingDataset= "GFDLESM2M",
         forcingCondition="rcp2p6", variables = "tmax_degC",
         period = c("2020-01-01", "2021-01-01"),
         aggregate = "month", FUN =difference)
abline(h = 0, col = "red")
}
}
\keyword{ProfoundData}
