% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{normalize}
\alias{normalize}
\title{Normalize all word vectors to the unit length 1.}
\usage{
normalize(x)
}
\arguments{
\item{x}{A \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix),
see \code{\link{data_wordvec_load}}.}
}
\value{
A \code{wordvec} (data.table) or \code{embed} (matrix) with \strong{normalized} word vectors.
}
\description{
L2-normalization (scaling to unit euclidean length):
the \emph{norm} of each vector in the vector space will be normalized to 1.
It is necessary for any linear operation of word vectors.

R code:
\itemize{
  \item{Vector: \code{vec / sqrt(sum(vec^2))}}
  \item{Matrix: \code{mat / sqrt(rowSums(mat^2))}}
}
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = normalize(demodata)
# the same: d = as_wordvec(demodata, normalize=TRUE)

}
\seealso{
\code{\link{as_wordvec}} / \code{\link{as_embed}}

\code{\link{load_wordvec}} / \code{\link{load_embed}}

\code{\link{data_transform}}

\code{\link{data_wordvec_subset}}
}
