% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sids.R
\name{get_sids}
\alias{get_sids}
\title{Retrieve Substance IDs (SIDs) from PubChem}
\usage{
get_sids(
  identifier,
  namespace = "cid",
  domain = "compound",
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A numeric or character vector specifying the identifiers for the request.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'cid'.}

\item{domain}{A character string specifying the domain for the request. Default is 'compound'.}

\item{searchtype}{A character string specifying the search type. Default is NULL.}

\item{options}{Additional arguments passed to the PubChem request.}
}
\value{
An object of class 'PubChemInstance_SIDs', which is a list containing information retrieved from the PubChem database. Substance IDs can be extracted from the returned object using the \link{SIDs} function.
}
\description{
This function sends a request to PubChem to retrieve Substance IDs (SIDs) for a given identifier.
}
\examples{
result <- get_sids(
  identifier = c("aspirin", "ibuprofen"),
  namespace = "name"
)

# Extract substance IDs of all compounds
SIDs(result)

}
