% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-PEESE.R
\name{method.PEESE}
\alias{method.PEESE}
\title{PEESE (Precision-Effect Estimate with Standard Errors) Method}
\usage{
\method{method}{PEESE}(method_name, data, settings = NULL)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (no settings version are implemented)}
}
\value{
Data frame with PEESE results
}
\description{
Implements the Precision-Effect Estimate with Standard Errors method for
publication bias correction. PEESE regresses effect sizes against standard
errors^2 to correct for publication bias. The intercept represents the
bias-corrected effect size estimate. See
\insertCite{stanley2014meta;textual}{PublicationBiasBenchmark} for details.
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply PEESE method
result <- run_method("PEESE", data)
print(result)

}
\references{
\insertAllCited{}
}
