% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-standard_curve.R
\name{plot_standard_curve_analyte_with_model}
\alias{plot_standard_curve_analyte_with_model}
\title{Plot standard curve of a certain analyte with fitted model}
\usage{
plot_standard_curve_analyte_with_model(
  plate,
  model,
  data_type = "Median",
  decreasing_dilution_order = TRUE,
  log_scale = c("all"),
  plot_asymptote = TRUE,
  plot_test_predictions = TRUE,
  plot_blank_mean = TRUE,
  plot_dilution_bounds = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{plate}{Plate object}

\item{model}{fitted \code{Model} object, which predictions we want to plot}

\item{data_type}{Data type of the value we want to plot - the same datatype as in the plate file. By default equals to \code{Median}}

\item{decreasing_dilution_order}{If \code{TRUE} the dilutions are plotted in decreasing order, \code{TRUE} by default.}

\item{log_scale}{Which elements on the plot should be displayed in log scale. By default \code{"all"}. If \code{NULL} or \code{c()} no log scale is used, if \code{"all"} or \code{c("dilutions", "MFI")} all elements are displayed in log scale.}

\item{plot_asymptote}{If \code{TRUE} the asymptotes are plotted, \code{TRUE} by default}

\item{plot_test_predictions}{If \code{TRUE} the predictions for the test samples are plotted, \code{TRUE} by default
The predictions are obtained through extrapolation of the model}

\item{plot_blank_mean}{If \code{TRUE} the mean of the blank samples is plotted, \code{TRUE} by default}

\item{plot_dilution_bounds}{If \code{TRUE} the dilution bounds are plotted, \code{TRUE} by default}

\item{verbose}{If \code{TRUE} prints messages, \code{TRUE} by default}
}
\value{
a ggplot object with the plot
}
\description{
Function plots the values of standard curve samples and the fitted model.
}
