% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AEPD.R
\name{AEPD}
\alias{AEPD}
\alias{dAEPD}
\alias{pAEPD}
\alias{qAEPD}
\alias{rAEPD}
\title{Quantile-based asymmetric exponential power distribution}
\usage{
dAEPD(y, mu, phi, alpha, p)

pAEPD(q, mu, phi, alpha, p)

qAEPD(beta, mu, phi, alpha, p)

rAEPD(n, mu, phi, alpha, p)
}
\arguments{
\item{y, q}{These are each a vector of quantiles.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{p}{This is the shape parameter, which must be positive.}

\item{beta}{This is a vector of probabilities.}

\item{n}{This is the number of observations, which must be a positive integer that has length 1.}
}
\value{
\code{\link{dAEPD}} provides the density, \code{\link{pAEPD}} provides the cumulative distribution function, \code{\link{qAEPD}} provides the quantile function, and \code{\link{rAEPD}} generates a random sample from the quantile-based asymmetric exponential power distribution.
}
\description{
Density, cumulative distribution function, quantile function and random sample generation
from the quantile-based asymmetric exponential power distribution (AEPD) studied in Gijbels et al. (2019b). An alternative form of the density AEPD is also studied in Komunjer (2007).
}
\examples{
# Quantile-based asymmetric exponential power distribution
# Density
rnum<-rnorm(100)
dAEPD(y=rnum,mu=0,phi=1,alpha=.5,p=2)

# Distribution function
pAEPD(q=rnum,mu=0,phi=1,alpha=.5,p=2)

# Quantile function
beta<-c(0.25,0.5,0.75)
qAEPD(beta=beta,mu=0,phi=1,alpha=.5,p=2)

# random sample generation
rAEPD(n=100,mu=0,phi=1,alpha=.5,p=2)

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.


 Komunjer, I., (2007). Asymmetric power distribution: theory and applications to risk measurement. \emph{Journal of Applied Econometrics}, \bold{22}(5), 891-921.

}
}
