% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATD.R
\name{mleATD}
\alias{mleATD}
\title{Maximum likelihood estimation (MLE) for the quantile-based asymmetric Student's-\eqn{t} distribution.}
\usage{
mleATD(y)
}
\arguments{
\item{y}{This is a vector of quantiles.}
}
\value{
The maximum likelihood estimate of parameter \eqn{\theta=(\mu,\phi,\alpha,\nu)} of the quantile-based asymmetric Student's-\eqn{t} distribution.
}
\description{
The log-likelihood function \eqn{\ell_n(\mu,\phi,\alpha,\nu)=\ln[L_n(\mu,\phi,\alpha,\nu)]}
and parameter estimation of \eqn{ \theta=(\mu,\phi,\alpha,\nu)} in the quantile-based asymmetric Student's-\eqn{t} distribution.
by using the maximum likelihood estimation are discussed in Gijbels et al. (2019a).
}
\examples{
\donttest{
# Example
y=rnorm(20)
mleATD(y)

}
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.
}
}
