% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{login_bms}
\alias{login_bms}
\title{Login to the Server}
\usage{
login_bms(username = NULL, password = NULL, encoding = "json")
}
\arguments{
\item{username}{The username (optional, default is NULL).}

\item{password}{The password (optional, default is NULL).}

\item{encoding}{How should the named list body be encoded? Can be one of form 
(application/x-www-form-urlencoded), multipart (multipart/form-data), 
or json (application/json).}
}
\value{
No return value.
}
\description{
Connects to the server. If the username or password parameters are missing,
then a login window will pop up to insert the username and password.

All other connection parameters (i.e., server IP or domain, connection port,
API path, and connection protocol e.g., http://) will be retrieved from the
qbms_config list.

This function will update both the qbms_config list (brapi connection
object in the con key) and the qbms_state list (token value in the token key).
}
\examples{
if(interactive()) {
  # Configure your BMS connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your BMS account (interactive mode)
  # You can pass the BMS username and password as parameters (batch mode)
  login_bms()
}

}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
