% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsModel-class.R
\docType{class}
\name{tsModel-class}
\alias{tsModel-class}
\alias{tsModel}
\title{Class for a Parametric Time-Series Model}
\description{
\code{tsModel} is a class to contain parametric time-series models (like ARMA
 oder GARCH) so that they can be used as arguments for \link{qpBoot}. There
 are some premade \link{Models}
}
\section{Slots}{

\describe{
\item{\code{name}}{the name of the model (e.g. "GARCH")}

\item{\code{spec}}{a list containing additional specification of the model}

\item{\code{env}}{An environment to allow for slots which need to be
    accessable in a call-by-reference manner:
\describe{
  \item{\code{est_function}}{a function implementing an estimator for the
  parameters of the model. It has the argumens \code{object} and \code{data} and 
  returns the estimated parameter. Also it sets \code{par} to the estimated value.}
  \item{\code{sim_function}}{a function implementing a way to simulate from the
  the model. It has the argumens \code{object} and \code{n}. Note that \code{par}
  has to be set in order to simulate.}
  \item{\code{par}}{a numeric vector that contains the parameters of the model. Can be
  empty at the beginning.}
   }}
}}

\keyword{S4-classes}
