% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleQp.R
\name{sampleQp}
\alias{sampleQp}
\title{Cluster-Specific Sample Quantiles}
\usage{
sampleQp(
  data,
  subjID = "PATIENT_ID",
  Qpredictor = "Marker",
  FUN = "quantile",
  include = setdiff(names(data), y = c(Qpredictor)),
  exclude = NULL,
  nQ = 101L,
  type = 7,
  ...
)
}
\arguments{
\item{data}{\link[base]{data.frame}}

\item{subjID}{\link[base]{character} scalar, column name of the subject/patient index in \code{data}}

\item{Qpredictor}{\link[base]{character} scalar, column name of the predictor variable}

\item{FUN}{\link[base]{function} for summary statistics, currently only supports \link[stats]{quantile}}

\item{include}{\link[base]{character} \link{vector}, predictors to be included}

\item{exclude}{\link[base]{character} \link{vector}, predictors to be excluded}

\item{nQ}{\link[base]{integer} scalar, number of equidistant quantiles between 0 and 1 (inclusive).
Default is \code{101L}.}

\item{type}{\link[base]{integer} scalar, see \link[stats]{quantile}}

\item{...}{additional parameters, currently not in use.}
}
\value{
\link{sampleQp} returns a \link[base]{data.frame}, with aggregated \link[survival]{Surv} endpoint and
\link[base]{numeric}, \link[base]{character}, or \link[base]{logical} predictors,
in addition to a \link[base]{matrix} of quantiles.
}
\description{
This function calculates vectors of \code{nQ} sample quantiles in each independent cluster of observations (sample or subject)
Equidistant probabilities between 0 and 1 are used (including both ends).
}
\details{
\link{sampleQp} calculates \eqn{N_p} sample quantiles in each independent cluster of observations
defined by \code{subjID} or \code{sampleID}.
Sample quantiles are stored in \eqn{N_p} columns for \eqn{Q(p)}, \eqn{p=1, \cdots, Np}
Additional subject-level predictors may be designated to be kept in the data set.
}
\examples{
Ki67_Qps = sampleQp(data = Ki67, subjID = 'PATIENT_ID', Qpredictor = 'Marker')
head(Ki67_Qps)
sapply(Ki67_Qps, FUN = class)   
head(Ki67_Qps$Marker)
   
PR_Qps = sampleQp(data = PR, subjID = 'PATIENT_ID',  Qpredictor = 'Marker')

}
