% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0stratifiedSplitSample.R
\name{stratifiedSplitSample}
\alias{stratifiedSplitSample}
\title{Stratified Split Sampling}
\usage{
stratifiedSplitSample(x, nsplit, trainFrac = 0.8, ...)
}
\arguments{
\item{x}{a \link[base]{numeric} \link[base]{vector},
a \link[base]{logical} \link[base]{vector},
a \link[base]{factor},
or a \link[survival]{Surv} object,
endpoint of the analysis, on which the stratification will be based}

\item{nsplit}{\link[base]{integer} scalar, copies of sample split to be performed}

\item{trainFrac}{\link[base]{numeric} scalar between 0 and 1,
fraction of the training set, default \code{.8}}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{stratifiedSplitSample} returns a \link[base]{list} of length \code{nsplit}, each element of which
is a \link[base]{list} of two elements
\describe{
\item{\code{train}}{\link[base]{integer} \link[base]{vector}, \link[base]{sort}ed indexes of the training set}
\item{\code{test}}{\link[base]{integer} \link[base]{vector}, \link[base]{sort}ed indexes of the test set}
}
}
\description{
Split sampling, stratified based on the type of the endpoint.
}
\details{
Split a \link[survival]{Surv} endpoint, stratified by the censoring status.
Specifically,
split subjects with observed event into a training and a test set with training set fraction \code{trainFrac},
and split the censored subjects into a training and a test set with training set fraction \code{trainFrac}.
Then combine the training sets from subjects with observed events and censored subjects,
and combine the test sets from subjects with observed events and censored subjects.

Split a \link[base]{logical} endpoint, stratified by the endpoint itself.
Specifically,
split the subjects with \code{TRUE} endpoint into a training and a test set with training set fraction \code{trainFrac},
and split the subjects with \code{FALSE} endpoint into a training and a test set with training set fraction \code{trainFrac}.
Then combine the training sets, and the test sets, in a similar fashion as described above.

Split a \link[base]{factor} endpoint, stratified by the level of the endpoint.
Specifically,
split the subjects in each \link[base]{levels} of the endpoint into a training and a test set by ratio \code{trainFrac}.
Then combine the training sets, and the test sets, from all levels of the endpoint.

Split a \link[base]{numeric} endpoint into a training and a test set by ratio \code{trainFrac}, without stratification.
}
\note{
\code{caTools::sample.split} is not what we need.
}
\examples{
stratifiedSplitSample(x = rep(c(TRUE, FALSE), times = c(20, 30)), nsplit = 5L)

}
