% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0Int_base_stats.R
\name{allequal}
\alias{allequal}
\alias{allequal_dbl}
\alias{unique_allequal}
\alias{duplicated_allequal}
\title{Determine Duplicate Elements by \code{\link[base]{all.equal.numeric}}}
\usage{
allequal_dbl(target, current, tolerance = sqrt(.Machine$double.eps))

unique_allequal(x, tolerance = sqrt(.Machine$double.eps))

duplicated_allequal(x, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{target}{\code{\link[base]{double}} vector, missing value \code{NA_real_} is not allowed}

\item{current}{\code{\link[base]{double}} vector, missing value \code{NA_real_} is not allowed}

\item{tolerance}{see \code{\link[base]{all.equal.numeric}}.}

\item{x}{\code{\link[base]{double}} vector}
}
\value{
\code{\link{allequal_dbl}} returns a \code{\link[base]{logical}} \code{\link[base]{matrix}}
indicating whether the vector \code{current} is element-wise near-equal to the vector \code{target} 
within the prespecified \code{tolerance}.  
This function is different from \code{\link[base]{all.equal.numeric}}, such that 
(1). only comparisons between real \code{\link[base]{double}} values are performed;
(2). element-wise comparison is performed, with the rows of returned \code{\link[base]{matrix}} correspond to \code{current}
and columns correspond to \code{target};
(3). a \code{\link[base]{logical}} scalar is returned for each element-wise comparison.

\code{\link{duplicated_allequal}} returns a \code{\link[base]{logical}} vector of the same length as the input \code{x},
indicating whether each element is a duplicate give the previous elements.  
This function behaves otherwise similar to \code{\link[base]{duplicated.default}}, 
with the only difference that the comparison is performed by \code{\link{allequal_dbl}}.

\code{\link{unique_allequal}} returns the unique (determined by \code{\link{allequal_dbl}}) elements in the input \code{x},
behaving otherwise similar to \code{\link[base]{unique.default}}.
}
\description{
Determine duplicate elements and extract unique elements in \code{\link[base]{double}} vector, 
similar to \code{\link[base]{duplicated}} and \code{\link[base]{unique}},
using the algorithm given in \code{\link[base]{all.equal.numeric}}.
}
\examples{
x = c(.3, 1-.7, 0, .Machine$double.eps)
allequal_dbl(current = x, target = c(.3, 0))
unique.default(x) # not desired
unique_allequal(x) # desired

}
