% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Plot.R
\name{plot}
\alias{plot}
\alias{plot.CDM}
\alias{plot.sim.data}
\alias{plot.validation}
\title{Plot Methods for Various Qval Objects}
\usage{
\method{plot}{CDM}(x, ...)

\method{plot}{sim.data}(x, ...)

\method{plot}{validation}(x, i = 1, ...)
}
\arguments{
\item{x}{An object of class \code{\link[Qval]{CDM}}, \code{\link[Qval]{sim.data}}, or \code{\link[Qval]{validation}}.}

\item{...}{Additional arguments (currently unused).}

\item{i}{For \code{validation} objects, the index of the item for which to plot the Hull curve.}
}
\value{
None. Functions are called for side effects (plotting).
}
\description{
Generate visualizations for objects created by the Qval package. The generic `plot` dispatches to
appropriate methods based on object class:
\describe{
  \item{CDM}{Barplot of attribute-pattern distribution (frequency and proportion).}
  \item{sim.data}{Barplot of simulated attribute-pattern distribution (frequency and proportion).}
  \item{validation}{Hull plot marking the suggested point in red (method = "Hull").}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{plot(CDM)}: Plot method for CDM objects

\item \code{plot(sim.data)}: Plot method for sim.data objects

\item \code{plot(validation)}: Hull plot for validation objects

}}
\examples{
set.seed(123)
library(Qval)

\donttest{
K <- 4
I <- 20
IQ <- list(
  P0 = runif(I, 0.2, 0.4),
  P1 = runif(I, 0.6, 0.8)
)

################################################################
# Example 1: sim.data object                                   #
################################################################
Q <- sim.Q(K, I)
data.obj <- sim.data(Q = Q, N = 500, IQ = IQ,
                     model = "GDINA", distribute = "horder")

plot(data.obj)
                     

################################################################
# Example 2: CDM object                                        #
################################################################
CDM.obj <- CDM(data.obj$dat, Q, model = "GDINA", 
               method = "EM", maxitr = 2000, verbose = 1)
plot(CDM.obj)


################################################################
# Example 3: validation object (Hull plot)                     #
################################################################
MQ <- sim.MQ(Q, 0.1)

CDM.obj <- CDM(data.obj$dat, MQ)

############### ESA ###############
Hull.obj <- validation(data.obj$dat, MQ, CDM.obj, 
                       method = "Hull", search.method = "ESA") 

## plot Hull curve for item 20
plot(Hull.obj, 20)

############### PAA ###############
Hull.obj <- validation(data.obj$dat, MQ, CDM.obj, 
                       method = "Hull", search.method = "PAA") 

## plot Hull curve for item 20
plot(Hull.obj, 20)
}

}
