% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord_r2d2.R
\name{ord_r2d2}
\alias{ord_r2d2}
\title{Ordinal regression in Stan with R2D2 prior}
\usage{
ord_r2d2(
  x,
  y,
  K,
  a = 1,
  b = 10,
  hyper = NULL,
  alpha = rep(1, K),
  nsims = 1000,
  nreps = 5,
  no_cores = 10,
  progress = FALSE,
  ...
)
}
\arguments{
\item{x}{covariate matrix}

\item{y}{response variables}

\item{K}{number of response categories}

\item{a}{hyper-parameter of prior for R2 ~ Beta(a,b)}

\item{b}{hyper-parameter of prior for R2 ~ Beta(a,b)}

\item{hyper}{hyper-parameters for W prior}

\item{alpha}{prior hyper-parameters for prior Dirichlet distribution on response probabilities}

\item{nsims}{number of times to simulate data}

\item{nreps}{number of times to run the algorithm (default = 5)}

\item{no_cores}{number of cores to parallelize data-generation process}

\item{progress}{logical. if TRUE, shows the progress bars from the posterior sampling.}

\item{...}{optional hyper-parameters for Stan fitting}
}
\value{
Stan model fit
}
\description{
This function carries out a Bayesian ordinal regression model
in Stan using the proposed psuedo-R2D2 prior
}
\examples{
\donttest{
# X are covariates, Y are responses, K is number of response categories
# This example will yield low R2 values as the response are independent of the covariates.
set.seed(1234)
n = 100
p = 5
X = matrix(rnorm(n*p), nrow = n, ncol=p)
K = 3
Y = sample(1:K, 100, replace=TRUE)
a = 1
b = 5
# Pre-computed hyperparameters
fit <- ord_r2d2(X, Y, K, hyper=c(0.002, 0.989, 1.013), no_cores=1)
out <- rstan::extract(fit)
# Plot histogram of posterior W
hist(out$W, xlab="W")
}
}
