% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mlwinfitIGLS.R
\docType{class}
\name{mlwinfitIGLS-class}
\alias{mlwinfitIGLS-class}
\title{An S4 class that stores the outputs of the fitted IGLS model.}
\description{
An MLwiN model run via the IGLS estimation method is represented by an "mlwinfitIGLS" object
}
\section{Slots}{

\describe{
\item{\code{Nobs}}{Computes the number of complete observations.}

\item{\code{DataLength}}{Total number of cases.}

\item{\code{Hierarchy}}{For each higher level of a multilevel model, returns the number of units at that level, together with the minimum, mean and maximum number of lower-level units nested within units of the current level.}

\item{\code{D}}{A vector specifying the type of distribution to be modelled, which can include \code{'Normal'}, \code{'Binomial'} \code{'Poisson'}, \code{'Multinomial'}, \code{'Multivariate Normal'}, or \code{'Mixed'}.}

\item{\code{Formula}}{A formula object (or a character string) specifying a multilevel model.}

\item{\code{levID}}{A character string (vector) of the specified level ID(s).}

\item{\code{FP}}{Displays the fixed part estimates.}

\item{\code{RP}}{Displays the random part estimates.}

\item{\code{FP.cov}}{Displays a covariance matrix of the fixed part estimates.}

\item{\code{RP.cov}}{Displays a covariance matrix of the random part estimates.}

\item{\code{elapsed.time}}{Calculates the CPU time used for fitting the model.}

\item{\code{call}}{The matched call.}

\item{\code{LIKE}}{The deviance statistic (-2*log(like)).}

\item{\code{Converged}}{Boolean indicating whether the model has converged}

\item{\code{Iterations}}{Number of iterations that the model has run for}

\item{\code{Meth}}{If \code{Meth = 0} estimation method is set to RIGLS. If \code{Meth = 1} estimation method is set to IGLS.}

\item{\code{residual}}{If \code{resi.store} is \code{TRUE}, then the residual estimates at all levels are returned.}

\item{\code{data}}{The data.frame that was used to fit the model.}

\item{\code{nonlinear}}{A character vector specifying linearisation method used. The first element specifies marginal quasi-likelihood linearization (\code{N = 0}) or penalised quasi-likelihood linearization (\code{N = 1}); The second element specifies first (\code{M = 1}) or second (\code{M = 2}) order approximation.}

\item{\code{version}}{The MLwiN version used to fit the model}
}}
\section{An instance of the Class}{

 An instance is created by calling function \code{\link{runMLwiN}}.
}
\examples{
\dontrun{
library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

## Example: tutorial
data(tutorial, package = "R2MLwiN")

(mymodel <- runMLwiN(normexam ~ 1 + standlrt + (1 + standlrt | school) + (1 | student),
                     data = tutorial))

##summary method
summary(mymodel)

##logLik method
logLik(mymodel)
}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{runMLwiN}}
}

