% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{run_app}
\alias{run_app}
\title{Run a package app}
\usage{
run_app(
  which = c("risk-adjusted-returns", "purchasing-power", "retirement-ruin"),
  res = 120,
  shinylive = FALSE
)
}
\arguments{
\item{which}{A character. The name of the app to run.
Currently available:
\itemize{
\item \code{risk-adjusted-returns} - Plotting risk-adjusted returns for various allocations to the risky asset allows you to find the optimal allocation.
\item \code{purchasing-power} - Plotting the effect of real interest rates
(positive or negative) on the purchasing power of savings over time.
\item \code{retirement-ruin} - Plotting the probability of retirement ruin.
}}

\item{res}{A numeric. The initial resolution of the plots.}

\item{shinylive}{A logical. Whether to use \code{shinylive} for the app.}
}
\value{
A \code{\link[shiny:shinyApp]{shiny::shinyApp()}} object if \code{shinylive} is \code{TRUE}.
Runs the app if \code{shinylive} is \code{FALSE} with \code{\link[shiny:runApp]{shiny::runApp()}}.
}
\description{
Run a package app
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
run_app("risk-adjusted-returns")
run_app("purchasing-power")
run_app("retirement-ruin")
\dontshow{\}) # examplesIf}
}
