% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R62S4.R
\name{R62S4}
\alias{R62S4}
\title{S4 Method Generator from R6 Class}
\usage{
R62S4(
  R6Class,
  dispatchClasses = list(R6Class),
  assignEnvir = parent.env(environment()),
  mask = FALSE,
  scope = "public",
  arg1 = "object",
  exclude = NULL
)
}
\arguments{
\item{R6Class}{R6ClassGenerator to generate public methods from}

\item{dispatchClasses}{list of classes to assign dispatch methods on}

\item{assignEnvir}{environment in which to assign the generics/methods, default is parent of current environment.}

\item{mask}{logical, determines if non-generic functions should be masked if found, see details.}

\item{scope}{determines the scope of methods that should be copied, either \code{"public"}, \code{"active"} or both}

\item{arg1}{if \code{mask == TRUE} or no generic is found, then \code{arg1} determines what name to give to the first argument in the generic.}

\item{exclude}{an optional character vector naming the public methods or active bindings to exclude from the generator}
}
\value{
Assigns generics/methods/functions to the chosen environment.

Assigns methods and generics to the chosen environment.
}
\description{
Auto-generates S4 generics from an R6 Class.
}
\details{
If \code{scope == "public"} then searches in a given \link[R6:R6Class]{R6::R6Class} for all public methods that are not \code{initialize} or \code{clone}.
If \code{scope == "active"} then searches for all active bindings. Currently there is only support for
calling active bindings but not setting them. If \verb{scope == c("public", active")} then both are included.
Any methods/bindings passed to \code{exclude} will be ignored in the search.

If \code{mask == TRUE} then the generator ignores if a generic or method of the same name exists and will
create a new S4 generic/method. If
\code{mask == FALSE} then the generator will create a new generic only if an existing generic does not
already exist. Methods and generics are created using standard convention.

The optional \code{dispatchClasses} argument takes a list of \link[R6:R6Class]{R6::R6Class}es and allows methods to be
created for multiple classes at one time.

S4 generics are detected with \code{\link[methods:.S4methods]{methods::.S4methods()}}.
}
\examples{
printMachine <- R6::R6Class("printMachine",
        public = list(initialize = function() {},
                      printer = function(str) print(str)),
        active = list(Status = function() "Printing"))

pm <- printMachine$new()

# scope = public
R62S4(printMachine, assignEnvir = topenv())
printer(pm, "Test String B")

# scope = active
R62S4(printMachine, assignEnvir = topenv(), scope = 'active')

# note support for accessing only, cannot assign
# values to an active binding
Status(pm)
}
\seealso{
\link[methods:setMethod]{methods::setMethod} \link[methods:setGeneric]{methods::setGeneric}

Other R62s: 
\code{\link{R62Fun}()},
\code{\link{R62S3}()}
}
\concept{R62s}
