% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMM_functions_cpp.R
\name{score.cpp}
\alias{score.cpp}
\title{Calculte -log10(p) by score test (slow, for general cases)}
\usage{
score.cpp(y, Gs, Gu, Ge, P0, chi0.mixture = 0.5)
}
\arguments{
\item{y}{A \eqn{n \times 1} vector. A vector of phenotypic values should be used. NA is allowed.}

\item{Gs}{A list of kernel matrices you want to test. For example, Gs = list(A.part = K.A.part, D.part = K.D.part)}

\item{Gu}{A \eqn{n \times n} matrix. You should assign \eqn{ZKZ'}, where K is covariance (relationship) matrix and Z is its design matrix.}

\item{Ge}{A \eqn{n \times n} matrix. You should assign identity matrix I (diag(n)).}

\item{P0}{A \eqn{n \times n} matrix. The Moore-Penrose generalized inverse of \eqn{SV0S}, where \eqn{S = X(X'X)^{-1}X'} and
\eqn{V0 = \sigma^2_u Gu + \sigma^2_e Ge}. \eqn{\sigma^2_u} and \eqn{\sigma^2_e} are estimators of the null model.}

\item{chi0.mixture}{RAINBOW assumes the test statistic \eqn{l1' F l1} is considered to follow a x chisq(df = 0) + (1 - a) x chisq(df = r).
where l1 is the first derivative of the log-likelihood and F is the Fisher information. And r is the degree of freedom.
The argument chi0.mixture is a (0 <= a < 1), and default is 0.5.}
}
\value{
-log10(p) calculated by score test
}
\description{
Calculte -log10(p) by score test (slow, for general cases)
}
