% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.aggregate.vars.r
\name{lsa.aggregate.vars}
\alias{lsa.aggregate.vars}
\title{Aggregate variables in LSA datasets}
\usage{
lsa.aggregate.vars(
  data.file,
  data.object,
  group.vars,
  src.variables,
  new.variables,
  new.var.labels,
  aggr.fun,
  out.file
)
}
\arguments{
\item{data.file}{The file containing \code{lsa.data} object. Either this or
\code{data.object}
shall be specified, but not both. See details.}

\item{data.object}{The object in the memory containing \code{lsa.data} object. Either this
or \code{data.file} shall be specified, but not both. See details.}

\item{group.vars}{Variable(s) to aggregate the \code{src.variables} by. If no grouping
variables are provided, the \code{src.variables} will be aggregated on
country level. See details.}

\item{src.variables}{Names of the variables to aggregate. Accepts only continuous variables.
No PV variables are accepted. See details.}

\item{new.variables}{The names of the new, aggregated variables to append to the dataset.
See details.}

\item{new.var.labels}{Optional, vector of strings to add as variable labels for the
\code{new.variables}. See details.}

\item{aggr.fun}{Function to apply when aggregating the \code{variable}. Accepts
\code{mean} (default), \code{median}, or \code{mode}. See details.}

\item{out.file}{Full path to the \code{.RData} file to be written. If missing, the
original object will be overwritten in the memory. See examples.}
}
\value{
A \code{lsa.data} object in memory (if \code{out.file} is missing) or \code{.RData} file containing \code{lsa.data} object with the new aggregated variables.
}
\description{
\code{lsa.aggregate.vars} aggregates continuous variables by group and appends them to the dataset.
}
\details{
The function aggregates continuous variables in large-scale assessments' data. The aggregation can be done by groups defined by the \code{group.vars}. Multiple grouping variables can be specified. All aggregations are done within each country separately.

Either \code{data.file} or \code{data.object} shall be provided as source of data. If both of them are provided, the function will stop with an error message.

The \code{src.variables} specifies the variables that shall be aggregated. Only continuous variables are accepted. PVs are not accepted.

The \code{new.variables} argument is optional and specifies the names of the new variables aggregated from the \code{src.variables}. The sequence of the \code{new.variables} names is the same as the \code{src.variables}. If the \code{new.variables} argument is omitted, the function will create the names automatically, appending \code{AGGR} at the end of the \code{src.variables} and store the aggregated variable data under these names. If provided, the number of \code{new.variables} must be the same as the number of \code{src.variables}.

The \code{new.var.labels} is optional. Regardless whether \code{new.variables} are provided, if \code{new.var.labels} are provided, they will be assigned to the \code{new.variables} generated from the aggregation. If neither \code{new.variables} not \code{new.var.labels} are provided, the function will automatically generate \code{new.variables} (see above) and copy the variable labels from \code{src.variables} to the newly generated variables, appending \code{Aggregated} at the beginning. The argument takes a vector with the same number of elements as the number of variable names in \code{src.variables}.

The \code{aggr.fun} specifies the function to be applied when performing the aggregation. The acceptable values are \code{mean} (default), \code{median} and \code{mode}. Using these methods, the aggregation will be performed by groups defined by the \code{group.vars} within each country.

If full path to \code{.RData} file is provided to \code{out.file}, the data.set will be written to that file. If no, the complemeted data will remain in the memory.
}
\examples{

# Aggregate the PIRLS 2021 Students Like Reading and the Home Resources for Learning scales per
# school and save the dataset into a file, overwiriting it. The names for the new variables
# are automatically generated.
\dontrun{
lsa.aggregate.vars(data.file = "C:/Data/PIRLS_2021_Student_Miss_to_NA.RData",
src.variables = c("ASBGSLR", "ASBGHRL"), group.vars = "IDSCHOOL",
out.file = "/tmp/test.RData")
}

# Same as the above, but assign custom variable names and their labels, and write the data to
# the memory instead of saving it on the disk.
\dontrun{
lsa.aggregate.vars(data.file = "C:/Data/PIRLS_2021_Student_Miss_to_NA.RData",
src.variables = c("ASBGSLR", "ASBGHRL"), new.variables = c("LIKEREAD", "LRNRES"),
new.var.labels = c("Aggregated like reading", "Aggregated learning resources"),
group.vars = "IDSCHOOL",
out.file = "/tmp/test.RData")
}

}
\seealso{
\code{\link{lsa.convert.data}}
}
