% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.z.R
\name{assign.z}
\alias{assign.z}
\title{assign.z}
\usage{
assign.z(
  ramclustObj = NULL,
  chargestate = c(1:5),
  mzError = 0.02,
  nEvents = 2,
  minPercentSignal = 10,
  assume1 = TRUE
)
}
\arguments{
\item{ramclustObj}{ramclustR object to annotate}

\item{chargestate}{integer vector. vector of integers of charge states to look for.  default = c(1:5)}

\item{mzError}{numeric. the error allowed in charge state m/z filtering.  absolute mass units}

\item{nEvents}{integer. the number of isotopes necessary to assign a charnge state > 1.  default = 2.}

\item{minPercentSignal}{numeric.  the ratio of isotope signal (all isotopes) divided by total spectrum signal * 100 much be greater than minPercentSignal to evaluate charge state. Value should be between 0 and 100.}

\item{assume1}{logical.  when TRUE, m/z values for which no isotopes are found are assumed to be at z = 1.}
}
\value{
returns a ramclustR object.  new slots holding:

zmax. vector with length equal to number of compounds.  max charge state detected for that compound

fm. vector of inferred 'm', m/z value * z value

fz. vector of inferred 'z' values based on analysis of isotopes in spectrum.
}
\description{
infer charge state of features in ramclustR object.
}
\details{
Annotation of ramclustR spectra. looks at isotope spacing for clustered features to infer charge state for each feature and a max charge state for each compound
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.

Broeckling CD, Ganna A, Layer M, Brown K, Sutton B, Ingelsson E, Peers G, Prenni JE. Enabling Efficient and Confident Annotation of LC-MS Metabolomics Data through MS1 Spectrum and Time Prediction. Anal Chem. 2016 Sep 20;88(18):9226-34. doi: 10.1021/acs.analchem.6b02479. Epub 2016 Sep 8. PubMed PMID: 7560453.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{charge state}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramlclustR}
\concept{xcms}
