// Generated by rstantools.  Do not edit by hand.

/*
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_gMAP_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'gMAP', line 126, column 2 to column 32)",
                                                      " (in 'gMAP', line 127, column 2 to column 31)",
                                                      " (in 'gMAP', line 128, column 2 to column 30)",
                                                      " (in 'gMAP', line 131, column 2 to column 18)",
                                                      " (in 'gMAP', line 132, column 2 to column 23)",
                                                      " (in 'gMAP', line 133, column 2 to column 18)",
                                                      " (in 'gMAP', line 134, column 2 to column 27)",
                                                      " (in 'gMAP', line 135, column 2 to column 29)",
                                                      " (in 'gMAP', line 136, column 2 to column 59)",
                                                      " (in 'gMAP', line 141, column 4 to column 61)",
                                                      " (in 'gMAP', line 139, column 4 to column 28)",
                                                      " (in 'gMAP', line 138, column 2 to line 141, column 61)",
                                                      " (in 'gMAP', line 142, column 2 to column 37)",
                                                      " (in 'gMAP', line 147, column 4 to column 61)",
                                                      " (in 'gMAP', line 145, column 4 to column 30)",
                                                      " (in 'gMAP', line 144, column 2 to line 147, column 61)",
                                                      " (in 'gMAP', line 148, column 2 to column 44)",
                                                      " (in 'gMAP', line 185, column 2 to column 18)",
                                                      " (in 'gMAP', line 186, column 2 to column 23)",
                                                      " (in 'gMAP', line 188, column 19 to column 91)",
                                                      " (in 'gMAP', line 188, column 2 to column 91)",
                                                      " (in 'gMAP', line 189, column 19 to column 91)",
                                                      " (in 'gMAP', line 189, column 2 to column 91)",
                                                      " (in 'gMAP', line 190, column 16 to column 55)",
                                                      " (in 'gMAP', line 190, column 2 to column 55)",
                                                      " (in 'gMAP', line 191, column 16 to column 56)",
                                                      " (in 'gMAP', line 191, column 2 to column 56)",
                                                      " (in 'gMAP', line 192, column 16 to column 56)",
                                                      " (in 'gMAP', line 192, column 2 to column 56)",
                                                      " (in 'gMAP', line 157, column 21 to column 124)",
                                                      " (in 'gMAP', line 157, column 4 to column 124)",
                                                      " (in 'gMAP', line 158, column 21 to column 140)",
                                                      " (in 'gMAP', line 158, column 4 to column 140)",
                                                      " (in 'gMAP', line 155, column 9 to line 159, column 3)",
                                                      " (in 'gMAP', line 153, column 21 to column 60)",
                                                      " (in 'gMAP', line 153, column 4 to column 60)",
                                                      " (in 'gMAP', line 154, column 21 to column 60)",
                                                      " (in 'gMAP', line 154, column 4 to column 60)",
                                                      " (in 'gMAP', line 151, column 11 to line 155, column 3)",
                                                      " (in 'gMAP', line 151, column 2 to line 159, column 3)",
                                                      " (in 'gMAP', line 161, column 2 to column 56)",
                                                      " (in 'gMAP', line 163, column 27 to column 67)",
                                                      " (in 'gMAP', line 163, column 2 to column 67)",
                                                      " (in 'gMAP', line 165, column 27 to column 83)",
                                                      " (in 'gMAP', line 165, column 2 to column 83)",
                                                      " (in 'gMAP', line 167, column 27 to column 83)",
                                                      " (in 'gMAP', line 167, column 2 to column 83)",
                                                      " (in 'gMAP', line 168, column 27 to column 83)",
                                                      " (in 'gMAP', line 168, column 2 to column 83)",
                                                      " (in 'gMAP', line 169, column 27 to column 83)",
                                                      " (in 'gMAP', line 169, column 2 to column 83)",
                                                      " (in 'gMAP', line 170, column 27 to column 83)",
                                                      " (in 'gMAP', line 170, column 2 to column 83)",
                                                      " (in 'gMAP', line 171, column 27 to column 83)",
                                                      " (in 'gMAP', line 171, column 2 to column 83)",
                                                      " (in 'gMAP', line 172, column 27 to column 83)",
                                                      " (in 'gMAP', line 172, column 2 to column 83)",
                                                      " (in 'gMAP', line 173, column 27 to column 64)",
                                                      " (in 'gMAP', line 173, column 2 to column 64)",
                                                      " (in 'gMAP', line 175, column 27 to column 64)",
                                                      " (in 'gMAP', line 175, column 2 to column 64)",
                                                      " (in 'gMAP', line 179, column 18 to column 60)",
                                                      " (in 'gMAP', line 179, column 4 to column 60)",
                                                      " (in 'gMAP', line 180, column 18 to column 54)",
                                                      " (in 'gMAP', line 180, column 4 to column 54)",
                                                      " (in 'gMAP', line 181, column 18 to column 58)",
                                                      " (in 'gMAP', line 181, column 4 to column 58)",
                                                      " (in 'gMAP', line 178, column 16 to line 182, column 3)",
                                                      " (in 'gMAP', line 178, column 2 to line 182, column 3)",
                                                      " (in 'gMAP', line 17, column 2 to column 17)",
                                                      " (in 'gMAP', line 19, column 2 to column 28)",
                                                      " (in 'gMAP', line 21, column 9 to column 10)",
                                                      " (in 'gMAP', line 21, column 2 to column 14)",
                                                      " (in 'gMAP', line 22, column 9 to column 10)",
                                                      " (in 'gMAP', line 22, column 2 to column 17)",
                                                      " (in 'gMAP', line 25, column 8 to column 9)",
                                                      " (in 'gMAP', line 25, column 2 to column 29)",
                                                      " (in 'gMAP', line 26, column 8 to column 9)",
                                                      " (in 'gMAP', line 26, column 2 to column 29)",
                                                      " (in 'gMAP', line 28, column 8 to column 9)",
                                                      " (in 'gMAP', line 28, column 2 to column 30)",
                                                      " (in 'gMAP', line 29, column 9 to column 10)",
                                                      " (in 'gMAP', line 29, column 2 to column 26)",
                                                      " (in 'gMAP', line 31, column 2 to column 24)",
                                                      " (in 'gMAP', line 32, column 8 to column 9)",
                                                      " (in 'gMAP', line 32, column 2 to column 51)",
                                                      " (in 'gMAP', line 34, column 2 to column 43)",
                                                      " (in 'gMAP', line 35, column 2 to column 50)",
                                                      " (in 'gMAP', line 37, column 8 to column 9)",
                                                      " (in 'gMAP', line 37, column 2 to column 60)",
                                                      " (in 'gMAP', line 39, column 2 to column 18)",
                                                      " (in 'gMAP', line 41, column 9 to column 10)",
                                                      " (in 'gMAP', line 41, column 11 to column 13)",
                                                      " (in 'gMAP', line 41, column 2 to column 17)",
                                                      " (in 'gMAP', line 46, column 9 to column 11)",
                                                      " (in 'gMAP', line 46, column 2 to column 26)",
                                                      " (in 'gMAP', line 47, column 9 to column 21)",
                                                      " (in 'gMAP', line 47, column 2 to column 35)",
                                                      " (in 'gMAP', line 49, column 2 to column 39)",
                                                      " (in 'gMAP', line 50, column 2 to column 32)",
                                                      " (in 'gMAP', line 51, column 2 to column 29)",
                                                      " (in 'gMAP', line 53, column 2 to column 27)",
                                                      " (in 'gMAP', line 55, column 18 to column 20)",
                                                      " (in 'gMAP', line 55, column 2 to column 37)",
                                                      " (in 'gMAP', line 56, column 2 to column 36)",
                                                      " (in 'gMAP', line 58, column 2 to column 32)",
                                                      " (in 'gMAP', line 61, column 18 to column 20)",
                                                      " (in 'gMAP', line 61, column 2 to column 38)",
                                                      " (in 'gMAP', line 62, column 18 to column 30)",
                                                      " (in 'gMAP', line 62, column 2 to column 47)",
                                                      " (in 'gMAP', line 65, column 9 to column 10)",
                                                      " (in 'gMAP', line 65, column 12 to column 14)",
                                                      " (in 'gMAP', line 65, column 2 to column 24)",
                                                      " (in 'gMAP', line 67, column 8 to column 16)",
                                                      " (in 'gMAP', line 67, column 2 to column 107)",
                                                      " (in 'gMAP', line 69, column 4 to column 43)",
                                                      " (in 'gMAP', line 70, column 4 to column 43)",
                                                      " (in 'gMAP', line 68, column 18 to line 71, column 3)",
                                                      " (in 'gMAP', line 68, column 2 to line 71, column 3)",
                                                      " (in 'gMAP', line 74, column 4 to column 41)",
                                                      " (in 'gMAP', line 75, column 4 to column 41)",
                                                      " (in 'gMAP', line 73, column 28 to line 76, column 3)",
                                                      " (in 'gMAP', line 73, column 2 to line 76, column 3)",
                                                      " (in 'gMAP', line 79, column 4 to column 60)",
                                                      " (in 'gMAP', line 78, column 17 to line 80, column 3)",
                                                      " (in 'gMAP', line 78, column 2 to line 80, column 3)",
                                                      " (in 'gMAP', line 94, column 2 to column 30)",
                                                      " (in 'gMAP', line 95, column 27 to column 76)",
                                                      " (in 'gMAP', line 95, column 2 to column 76)",
                                                      " (in 'gMAP', line 96, column 27 to column 75)",
                                                      " (in 'gMAP', line 96, column 2 to column 75)",
                                                      " (in 'gMAP', line 97, column 27 to column 72)",
                                                      " (in 'gMAP', line 97, column 2 to column 72)",
                                                      " (in 'gMAP', line 99, column 27 to column 59)",
                                                      " (in 'gMAP', line 99, column 2 to column 59)",
                                                      " (in 'gMAP', line 100, column 27 to column 64)",
                                                      " (in 'gMAP', line 100, column 2 to column 64)",
                                                      " (in 'gMAP', line 101, column 27 to column 65)",
                                                      " (in 'gMAP', line 101, column 2 to column 65)",
                                                      " (in 'gMAP', line 102, column 27 to column 61)",
                                                      " (in 'gMAP', line 102, column 2 to column 61)",
                                                      " (in 'gMAP', line 103, column 27 to column 59)",
                                                      " (in 'gMAP', line 103, column 2 to column 59)",
                                                      " (in 'gMAP', line 104, column 27 to column 62)",
                                                      " (in 'gMAP', line 104, column 2 to column 62)",
                                                      " (in 'gMAP', line 105, column 27 to column 63)",
                                                      " (in 'gMAP', line 105, column 2 to column 63)",
                                                      " (in 'gMAP', line 106, column 27 to column 65)",
                                                      " (in 'gMAP', line 106, column 2 to column 65)",
                                                      " (in 'gMAP', line 107, column 27 to column 65)",
                                                      " (in 'gMAP', line 107, column 2 to column 65)",
                                                      " (in 'gMAP', line 108, column 27 to column 60)",
                                                      " (in 'gMAP', line 108, column 2 to column 60)",
                                                      " (in 'gMAP', line 109, column 27 to column 84)",
                                                      " (in 'gMAP', line 109, column 2 to column 84)",
                                                      " (in 'gMAP', line 114, column 4 to column 39)",
                                                      " (in 'gMAP', line 115, column 4 to column 16)",
                                                      " (in 'gMAP', line 118, column 8 to column 88)",
                                                      " (in 'gMAP', line 117, column 6 to line 118, column 88)",
                                                      " (in 'gMAP', line 119, column 6 to column 23)",
                                                      " (in 'gMAP', line 116, column 19 to line 120, column 5)",
                                                      " (in 'gMAP', line 116, column 4 to line 120, column 5)",
                                                      " (in 'gMAP', line 113, column 9 to line 121, column 3)",
                                                      " (in 'gMAP', line 111, column 4 to column 16)",
                                                      " (in 'gMAP', line 112, column 4 to column 43)",
                                                      " (in 'gMAP', line 110, column 10 to line 113, column 3)",
                                                      " (in 'gMAP', line 110, column 2 to line 121, column 3)",
                                                      " (in 'gMAP', line 123, column 4 to column 64)",
                                                      " (in 'gMAP', line 122, column 2 to line 123, column 64)",
                                                      " (in 'gMAP', line 126, column 9 to column 11)",
                                                      " (in 'gMAP', line 127, column 9 to column 21)",
                                                      " (in 'gMAP', line 128, column 9 to column 17)",
                                                      " (in 'gMAP', line 131, column 9 to column 10)",
                                                      " (in 'gMAP', line 132, column 9 to column 17)",
                                                      " (in 'gMAP', line 133, column 9 to column 11)",
                                                      " (in 'gMAP', line 134, column 9 to column 21)",
                                                      " (in 'gMAP', line 135, column 9 to column 17)"};
#include <stan_meta_header.hpp>
class model_gMAP final : public model_base_crtp<model_gMAP> {
private:
  int H;
  int link;
  Eigen::Matrix<double, -1, 1> y;
  Eigen::Matrix<double, -1, 1> y_se;
  std::vector<int> r;
  std::vector<int> r_n;
  std::vector<int> count;
  Eigen::Matrix<double, -1, 1> log_offset;
  int n_groups;
  std::vector<int> group_index;
  int n_tau_strata;
  int tau_strata_pred;
  std::vector<int> tau_strata_index;
  int mX;
  Eigen::Matrix<double, -1, -1> X;
  Eigen::Matrix<double, -1, -1> beta_prior;
  Eigen::Matrix<double, -1, -1> tau_prior;
  int tau_prior_dist;
  int re_dist;
  double re_dist_t_df;
  int ncp;
  std::vector<Eigen::Matrix<double, -1, 1>> beta_raw_guess;
  std::vector<double> tau_raw_guess;
  int prior_PD;
  std::vector<Eigen::Matrix<double, -1, 1>> beta_prior_stan;
  std::vector<Eigen::Matrix<double, -1, 1>> tau_prior_stan;
  Eigen::Matrix<double, -1, -1> X_param;
  std::vector<int> tau_strata_gindex;
 
public:
  ~model_gMAP() { }
  
  inline std::string model_name() const final { return "model_gMAP"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_gMAP(stan::io::var_context& context__,
             unsigned int random_seed__ = 0,
             std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_gMAP_namespace::model_gMAP";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 70;
      context__.validate_dims("data initialization","H","int",
          context__.to_vec());
      H = std::numeric_limits<int>::min();
      
      current_statement__ = 70;
      H = context__.vals_i("H")[(1 - 1)];
      current_statement__ = 70;
      current_statement__ = 70;
      check_greater_or_equal(function__, "H", H, 1);
      current_statement__ = 71;
      context__.validate_dims("data initialization","link","int",
          context__.to_vec());
      link = std::numeric_limits<int>::min();
      
      current_statement__ = 71;
      link = context__.vals_i("link")[(1 - 1)];
      current_statement__ = 71;
      current_statement__ = 71;
      check_greater_or_equal(function__, "link", link, 1);
      current_statement__ = 71;
      current_statement__ = 71;
      check_less_or_equal(function__, "link", link, 3);
      current_statement__ = 72;
      validate_non_negative_index("y", "H", H);
      current_statement__ = 73;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(H));
      y = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 73;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 73;
        pos__ = 1;
        current_statement__ = 73;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 73;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 73;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 74;
      validate_non_negative_index("y_se", "H", H);
      current_statement__ = 75;
      context__.validate_dims("data initialization","y_se","double",
          context__.to_vec(H));
      y_se = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(y_se, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_se_flat__;
        current_statement__ = 75;
        assign(y_se_flat__, nil_index_list(), context__.vals_r("y_se"),
          "assigning variable y_se_flat__");
        current_statement__ = 75;
        pos__ = 1;
        current_statement__ = 75;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 75;
          assign(y_se, cons_list(index_uni(sym1__), nil_index_list()),
            y_se_flat__[(pos__ - 1)], "assigning variable y_se");
          current_statement__ = 75;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 76;
      validate_non_negative_index("r", "H", H);
      current_statement__ = 77;
      context__.validate_dims("data initialization","r","int",
          context__.to_vec(H));
      r = std::vector<int>(H, std::numeric_limits<int>::min());
      
      current_statement__ = 77;
      assign(r, nil_index_list(), context__.vals_i("r"),
        "assigning variable r");
      current_statement__ = 77;
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        current_statement__ = 77;
        current_statement__ = 77;
        check_greater_or_equal(function__, "r[sym1__]", r[(sym1__ - 1)], 0);}
      current_statement__ = 78;
      validate_non_negative_index("r_n", "H", H);
      current_statement__ = 79;
      context__.validate_dims("data initialization","r_n","int",
          context__.to_vec(H));
      r_n = std::vector<int>(H, std::numeric_limits<int>::min());
      
      current_statement__ = 79;
      assign(r_n, nil_index_list(), context__.vals_i("r_n"),
        "assigning variable r_n");
      current_statement__ = 79;
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        current_statement__ = 79;
        current_statement__ = 79;
        check_greater_or_equal(function__, "r_n[sym1__]", r_n[(sym1__ - 1)],
                               1);}
      current_statement__ = 80;
      validate_non_negative_index("count", "H", H);
      current_statement__ = 81;
      context__.validate_dims("data initialization","count","int",
          context__.to_vec(H));
      count = std::vector<int>(H, std::numeric_limits<int>::min());
      
      current_statement__ = 81;
      assign(count, nil_index_list(), context__.vals_i("count"),
        "assigning variable count");
      current_statement__ = 81;
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        current_statement__ = 81;
        current_statement__ = 81;
        check_greater_or_equal(function__, "count[sym1__]",
                               count[(sym1__ - 1)], 0);}
      current_statement__ = 82;
      validate_non_negative_index("log_offset", "H", H);
      current_statement__ = 83;
      context__.validate_dims("data initialization","log_offset","double",
          context__.to_vec(H));
      log_offset = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(log_offset, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log_offset_flat__;
        current_statement__ = 83;
        assign(log_offset_flat__, nil_index_list(),
          context__.vals_r("log_offset"),
          "assigning variable log_offset_flat__");
        current_statement__ = 83;
        pos__ = 1;
        current_statement__ = 83;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 83;
          assign(log_offset, cons_list(index_uni(sym1__), nil_index_list()),
            log_offset_flat__[(pos__ - 1)], "assigning variable log_offset");
          current_statement__ = 83;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 84;
      context__.validate_dims("data initialization","n_groups","int",
          context__.to_vec());
      n_groups = std::numeric_limits<int>::min();
      
      current_statement__ = 84;
      n_groups = context__.vals_i("n_groups")[(1 - 1)];
      current_statement__ = 84;
      current_statement__ = 84;
      check_greater_or_equal(function__, "n_groups", n_groups, 1);
      current_statement__ = 85;
      validate_non_negative_index("group_index", "H", H);
      current_statement__ = 86;
      context__.validate_dims("data initialization","group_index","int",
          context__.to_vec(H));
      group_index = std::vector<int>(H, std::numeric_limits<int>::min());
      
      current_statement__ = 86;
      assign(group_index, nil_index_list(), context__.vals_i("group_index"),
        "assigning variable group_index");
      current_statement__ = 86;
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        current_statement__ = 86;
        current_statement__ = 86;
        check_greater_or_equal(function__, "group_index[sym1__]",
                               group_index[(sym1__ - 1)], 1);}
      current_statement__ = 86;
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        current_statement__ = 86;
        current_statement__ = 86;
        check_less_or_equal(function__, "group_index[sym1__]",
                            group_index[(sym1__ - 1)], n_groups);}
      current_statement__ = 87;
      context__.validate_dims("data initialization","n_tau_strata","int",
          context__.to_vec());
      n_tau_strata = std::numeric_limits<int>::min();
      
      current_statement__ = 87;
      n_tau_strata = context__.vals_i("n_tau_strata")[(1 - 1)];
      current_statement__ = 87;
      current_statement__ = 87;
      check_greater_or_equal(function__, "n_tau_strata", n_tau_strata, 1);
      current_statement__ = 87;
      current_statement__ = 87;
      check_less_or_equal(function__, "n_tau_strata", n_tau_strata, n_groups);
      current_statement__ = 88;
      context__.validate_dims("data initialization","tau_strata_pred","int",
          context__.to_vec());
      tau_strata_pred = std::numeric_limits<int>::min();
      
      current_statement__ = 88;
      tau_strata_pred = context__.vals_i("tau_strata_pred")[(1 - 1)];
      current_statement__ = 88;
      current_statement__ = 88;
      check_greater_or_equal(function__, "tau_strata_pred", tau_strata_pred,
                             1);
      current_statement__ = 88;
      current_statement__ = 88;
      check_less_or_equal(function__, "tau_strata_pred", tau_strata_pred,
                          n_tau_strata);
      current_statement__ = 89;
      validate_non_negative_index("tau_strata_index", "H", H);
      current_statement__ = 90;
      context__.validate_dims("data initialization","tau_strata_index","int",
          context__.to_vec(H));
      tau_strata_index = std::vector<int>(H, std::numeric_limits<int>::min());
      
      current_statement__ = 90;
      assign(tau_strata_index, nil_index_list(),
        context__.vals_i("tau_strata_index"),
        "assigning variable tau_strata_index");
      current_statement__ = 90;
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        current_statement__ = 90;
        current_statement__ = 90;
        check_greater_or_equal(function__, "tau_strata_index[sym1__]",
                               tau_strata_index[(sym1__ - 1)], 1);}
      current_statement__ = 90;
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        current_statement__ = 90;
        current_statement__ = 90;
        check_less_or_equal(function__, "tau_strata_index[sym1__]",
                            tau_strata_index[(sym1__ - 1)], n_tau_strata);}
      current_statement__ = 91;
      context__.validate_dims("data initialization","mX","int",
          context__.to_vec());
      mX = std::numeric_limits<int>::min();
      
      current_statement__ = 91;
      mX = context__.vals_i("mX")[(1 - 1)];
      current_statement__ = 91;
      current_statement__ = 91;
      check_greater_or_equal(function__, "mX", mX, 1);
      current_statement__ = 92;
      validate_non_negative_index("X", "H", H);
      current_statement__ = 93;
      validate_non_negative_index("X", "mX", mX);
      current_statement__ = 94;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(H, mX));
      X = Eigen::Matrix<double, -1, -1>(H, mX);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 94;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 94;
        pos__ = 1;
        current_statement__ = 94;
        for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
          current_statement__ = 94;
          for (int sym2__ = 1; sym2__ <= H; ++sym2__) {
            current_statement__ = 94;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 94;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 95;
      validate_non_negative_index("beta_prior", "mX", mX);
      current_statement__ = 96;
      context__.validate_dims("data initialization","beta_prior","double",
          context__.to_vec(mX, 2));
      beta_prior = Eigen::Matrix<double, -1, -1>(mX, 2);
      stan::math::fill(beta_prior, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_prior_flat__;
        current_statement__ = 96;
        assign(beta_prior_flat__, nil_index_list(),
          context__.vals_r("beta_prior"),
          "assigning variable beta_prior_flat__");
        current_statement__ = 96;
        pos__ = 1;
        current_statement__ = 96;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 96;
          for (int sym2__ = 1; sym2__ <= mX; ++sym2__) {
            current_statement__ = 96;
            assign(beta_prior,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              beta_prior_flat__[(pos__ - 1)], "assigning variable beta_prior");
            current_statement__ = 96;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 97;
      validate_non_negative_index("tau_prior", "n_tau_strata", n_tau_strata);
      current_statement__ = 98;
      context__.validate_dims("data initialization","tau_prior","double",
          context__.to_vec(n_tau_strata, 2));
      tau_prior = Eigen::Matrix<double, -1, -1>(n_tau_strata, 2);
      stan::math::fill(tau_prior, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tau_prior_flat__;
        current_statement__ = 98;
        assign(tau_prior_flat__, nil_index_list(),
          context__.vals_r("tau_prior"),
          "assigning variable tau_prior_flat__");
        current_statement__ = 98;
        pos__ = 1;
        current_statement__ = 98;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 98;
          for (int sym2__ = 1; sym2__ <= n_tau_strata; ++sym2__) {
            current_statement__ = 98;
            assign(tau_prior,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              tau_prior_flat__[(pos__ - 1)], "assigning variable tau_prior");
            current_statement__ = 98;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 99;
      context__.validate_dims("data initialization","tau_prior_dist","int",
          context__.to_vec());
      tau_prior_dist = std::numeric_limits<int>::min();
      
      current_statement__ = 99;
      tau_prior_dist = context__.vals_i("tau_prior_dist")[(1 - 1)];
      current_statement__ = 99;
      current_statement__ = 99;
      check_greater_or_equal(function__, "tau_prior_dist", tau_prior_dist, -1);
      current_statement__ = 99;
      current_statement__ = 99;
      check_less_or_equal(function__, "tau_prior_dist", tau_prior_dist, 7);
      current_statement__ = 100;
      context__.validate_dims("data initialization","re_dist","int",
          context__.to_vec());
      re_dist = std::numeric_limits<int>::min();
      
      current_statement__ = 100;
      re_dist = context__.vals_i("re_dist")[(1 - 1)];
      current_statement__ = 100;
      current_statement__ = 100;
      check_greater_or_equal(function__, "re_dist", re_dist, 0);
      current_statement__ = 100;
      current_statement__ = 100;
      check_less_or_equal(function__, "re_dist", re_dist, 1);
      current_statement__ = 101;
      context__.validate_dims("data initialization","re_dist_t_df","double",
          context__.to_vec());
      re_dist_t_df = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 101;
      re_dist_t_df = context__.vals_r("re_dist_t_df")[(1 - 1)];
      current_statement__ = 101;
      current_statement__ = 101;
      check_greater_or_equal(function__, "re_dist_t_df", re_dist_t_df, 0);
      current_statement__ = 102;
      context__.validate_dims("data initialization","ncp","int",
          context__.to_vec());
      ncp = std::numeric_limits<int>::min();
      
      current_statement__ = 102;
      ncp = context__.vals_i("ncp")[(1 - 1)];
      current_statement__ = 102;
      current_statement__ = 102;
      check_greater_or_equal(function__, "ncp", ncp, 0);
      current_statement__ = 102;
      current_statement__ = 102;
      check_less_or_equal(function__, "ncp", ncp, 1);
      current_statement__ = 103;
      validate_non_negative_index("beta_raw_guess", "mX", mX);
      current_statement__ = 104;
      context__.validate_dims("data initialization","beta_raw_guess",
          "double",context__.to_vec(2, mX));
      beta_raw_guess = std::vector<Eigen::Matrix<double, -1, 1>>(2, Eigen::Matrix<double, -1, 1>(mX));
      stan::math::fill(beta_raw_guess, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_raw_guess_flat__;
        current_statement__ = 104;
        assign(beta_raw_guess_flat__, nil_index_list(),
          context__.vals_r("beta_raw_guess"),
          "assigning variable beta_raw_guess_flat__");
        current_statement__ = 104;
        pos__ = 1;
        current_statement__ = 104;
        for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
          current_statement__ = 104;
          for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
            current_statement__ = 104;
            assign(beta_raw_guess,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              beta_raw_guess_flat__[(pos__ - 1)],
              "assigning variable beta_raw_guess");
            current_statement__ = 104;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 105;
      context__.validate_dims("data initialization","tau_raw_guess","double",
          context__.to_vec(2));
      tau_raw_guess = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 105;
      assign(tau_raw_guess, nil_index_list(),
        context__.vals_r("tau_raw_guess"), "assigning variable tau_raw_guess");
      current_statement__ = 106;
      context__.validate_dims("data initialization","prior_PD","int",
          context__.to_vec());
      prior_PD = std::numeric_limits<int>::min();
      
      current_statement__ = 106;
      prior_PD = context__.vals_i("prior_PD")[(1 - 1)];
      current_statement__ = 106;
      current_statement__ = 106;
      check_greater_or_equal(function__, "prior_PD", prior_PD, 0);
      current_statement__ = 106;
      current_statement__ = 106;
      check_less_or_equal(function__, "prior_PD", prior_PD, 1);
      current_statement__ = 107;
      validate_non_negative_index("beta_prior_stan", "mX", mX);
      current_statement__ = 108;
      beta_prior_stan = std::vector<Eigen::Matrix<double, -1, 1>>(2, Eigen::Matrix<double, -1, 1>(mX));
      stan::math::fill(beta_prior_stan, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 109;
      validate_non_negative_index("tau_prior_stan", "n_tau_strata",
                                  n_tau_strata);
      current_statement__ = 110;
      tau_prior_stan = std::vector<Eigen::Matrix<double, -1, 1>>(2, Eigen::Matrix<double, -1, 1>(n_tau_strata));
      stan::math::fill(tau_prior_stan, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 111;
      validate_non_negative_index("X_param", "H", H);
      current_statement__ = 112;
      validate_non_negative_index("X_param", "mX", mX);
      current_statement__ = 113;
      X_param = Eigen::Matrix<double, -1, -1>(H, mX);
      stan::math::fill(X_param, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 114;
      validate_non_negative_index("tau_strata_gindex", "n_groups", n_groups);
      current_statement__ = 115;
      tau_strata_gindex = std::vector<int>(n_groups, std::numeric_limits<int>::min());
      
      current_statement__ = 115;
      assign(tau_strata_gindex, nil_index_list(),
        rep_array(tau_strata_pred, n_groups),
        "assigning variable tau_strata_gindex");
      current_statement__ = 119;
      for (int i = 1; i <= mX; ++i) {
        current_statement__ = 116;
        assign(beta_prior_stan,
          cons_list(index_uni(1), cons_list(index_uni(i), nil_index_list())),
          rvalue(beta_prior,
            cons_list(index_uni(i),
              cons_list(index_uni(1), nil_index_list())), "beta_prior"),
          "assigning variable beta_prior_stan");
        current_statement__ = 117;
        assign(beta_prior_stan,
          cons_list(index_uni(2), cons_list(index_uni(i), nil_index_list())),
          rvalue(beta_prior,
            cons_list(index_uni(i),
              cons_list(index_uni(2), nil_index_list())), "beta_prior"),
          "assigning variable beta_prior_stan");}
      current_statement__ = 123;
      for (int i = 1; i <= n_tau_strata; ++i) {
        current_statement__ = 120;
        assign(tau_prior_stan,
          cons_list(index_uni(1), cons_list(index_uni(i), nil_index_list())),
          rvalue(tau_prior,
            cons_list(index_uni(i),
              cons_list(index_uni(1), nil_index_list())), "tau_prior"),
          "assigning variable tau_prior_stan");
        current_statement__ = 121;
        assign(tau_prior_stan,
          cons_list(index_uni(2), cons_list(index_uni(i), nil_index_list())),
          rvalue(tau_prior,
            cons_list(index_uni(i),
              cons_list(index_uni(2), nil_index_list())), "tau_prior"),
          "assigning variable tau_prior_stan");}
      current_statement__ = 126;
      for (int i = 1; i <= H; ++i) {
        current_statement__ = 124;
        assign(tau_strata_gindex,
          cons_list(index_uni(group_index[(i - 1)]), nil_index_list()),
          tau_strata_index[(i - 1)], "assigning variable tau_strata_gindex");
      }
      current_statement__ = 127;
      if (pstream__) {
        stan_print(pstream__, "Stan gMAP analysis");
        stan_print(pstream__, "\n");
      }
      current_statement__ = 129;
      if (logical_eq(link, 1)) {
        current_statement__ = 128;
        if (pstream__) {
          stan_print(pstream__, "likelihood:      Normal (identity link)");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 131;
      if (logical_eq(link, 2)) {
        current_statement__ = 130;
        if (pstream__) {
          stan_print(pstream__, "likelihood:      Binomial (logit link)");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 133;
      if (logical_eq(link, 3)) {
        current_statement__ = 132;
        if (pstream__) {
          stan_print(pstream__, "likelihood:      Poisson (log link)");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 135;
      if (logical_eq(tau_prior_dist, -1)) {
        current_statement__ = 134;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    Fixed");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 137;
      if (logical_eq(tau_prior_dist, 0)) {
        current_statement__ = 136;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    HalfNormal");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 139;
      if (logical_eq(tau_prior_dist, 1)) {
        current_statement__ = 138;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    TruncNormal");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 141;
      if (logical_eq(tau_prior_dist, 2)) {
        current_statement__ = 140;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    Uniform");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 143;
      if (logical_eq(tau_prior_dist, 3)) {
        current_statement__ = 142;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    Gamma");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 145;
      if (logical_eq(tau_prior_dist, 4)) {
        current_statement__ = 144;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    InvGamma");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 147;
      if (logical_eq(tau_prior_dist, 5)) {
        current_statement__ = 146;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    LogNormal");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 149;
      if (logical_eq(tau_prior_dist, 6)) {
        current_statement__ = 148;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    TruncCauchy");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 151;
      if (logical_eq(tau_prior_dist, 7)) {
        current_statement__ = 150;
        if (pstream__) {
          stan_print(pstream__, "tau distrib.:    Exponential");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 153;
      if (logical_eq(re_dist, 0)) {
        current_statement__ = 152;
        if (pstream__) {
          stan_print(pstream__, "random effects:  Normal");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 155;
      if (logical_eq(re_dist, 1)) {
        current_statement__ = 154;
        if (pstream__) {
          stan_print(pstream__, "random effects:  Student-t, df = ");
          stan_print(pstream__, re_dist_t_df);
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 167;
      if (ncp) {
        current_statement__ = 164;
        assign(X_param, nil_index_list(), X, "assigning variable X_param");
        current_statement__ = 165;
        if (pstream__) {
          stan_print(pstream__, "parametrization: Non-Centered");
          stan_print(pstream__, "\n");
        }
      } else {
        current_statement__ = 156;
        if (pstream__) {
          stan_print(pstream__, "parametrization: Centered");
          stan_print(pstream__, "\n");
        }
        current_statement__ = 157;
        assign(X_param, nil_index_list(), X, "assigning variable X_param");
        current_statement__ = 162;
        for (int i = 1; i <= H; ++i) {
          current_statement__ = 159;
          if (logical_neq(
                rvalue(X_param,
                  cons_list(index_uni(i),
                    cons_list(index_uni(1), nil_index_list())), "X_param"),
                1)) {
            current_statement__ = 158;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Centered parametrization requires treatment contrast parametrization!";
            throw std::domain_error(errmsg_stream__.str());
          } 
          current_statement__ = 160;
          assign(X_param,
            cons_list(index_uni(i),
              cons_list(index_uni(1), nil_index_list())), 0,
            "assigning variable X_param");}
      }
      current_statement__ = 169;
      if (prior_PD) {
        current_statement__ = 168;
        if (pstream__) {
          stan_print(pstream__, "Info: Sampling from prior predictive distribution.");
          stan_print(pstream__, "\n");
        }
      } 
      current_statement__ = 115;
      for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
        current_statement__ = 115;
        current_statement__ = 115;
        check_greater_or_equal(function__, "tau_strata_gindex[sym1__]",
                               tau_strata_gindex[(sym1__ - 1)], 1);}
      current_statement__ = 115;
      for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
        current_statement__ = 115;
        current_statement__ = 115;
        check_less_or_equal(function__, "tau_strata_gindex[sym1__]",
                            tau_strata_gindex[(sym1__ - 1)], n_tau_strata);}
      current_statement__ = 170;
      validate_non_negative_index("beta_raw", "mX", mX);
      current_statement__ = 171;
      validate_non_negative_index("tau_raw", "n_tau_strata", n_tau_strata);
      current_statement__ = 172;
      validate_non_negative_index("xi_eta", "n_groups", n_groups);
      current_statement__ = 173;
      validate_non_negative_index("theta", "H", H);
      current_statement__ = 174;
      validate_non_negative_index("eta", "n_groups", n_groups);
      current_statement__ = 175;
      validate_non_negative_index("beta", "mX", mX);
      current_statement__ = 176;
      validate_non_negative_index("tau", "n_tau_strata", n_tau_strata);
      current_statement__ = 177;
      validate_non_negative_index("tau_group", "n_groups", n_groups);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += mX;
      num_params_r__ += n_tau_strata;
      num_params_r__ += n_groups;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_gMAP_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta_raw;
      beta_raw = Eigen::Matrix<local_scalar_t__, -1, 1>(mX);
      stan::math::fill(beta_raw, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta_raw = in__.vector(mX);
      Eigen::Matrix<local_scalar_t__, -1, 1> tau_raw;
      tau_raw = Eigen::Matrix<local_scalar_t__, -1, 1>(n_tau_strata);
      stan::math::fill(tau_raw, DUMMY_VAR__);
      
      current_statement__ = 2;
      tau_raw = in__.vector(n_tau_strata);
      Eigen::Matrix<local_scalar_t__, -1, 1> xi_eta;
      xi_eta = Eigen::Matrix<local_scalar_t__, -1, 1>(n_groups);
      stan::math::fill(xi_eta, DUMMY_VAR__);
      
      current_statement__ = 3;
      xi_eta = in__.vector(n_groups);
      Eigen::Matrix<local_scalar_t__, -1, 1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, 1>(H);
      stan::math::fill(theta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> eta;
      eta = Eigen::Matrix<local_scalar_t__, -1, 1>(n_groups);
      stan::math::fill(eta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(mX);
      stan::math::fill(beta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> tau;
      tau = Eigen::Matrix<local_scalar_t__, -1, 1>(n_tau_strata);
      stan::math::fill(tau, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> tau_group;
      tau_group = Eigen::Matrix<local_scalar_t__, -1, 1>(n_groups);
      stan::math::fill(tau_group, DUMMY_VAR__);
      
      current_statement__ = 9;
      assign(beta, nil_index_list(),
        add(beta_raw_guess[(1 - 1)],
          elt_multiply(beta_raw_guess[(2 - 1)], beta_raw)),
        "assigning variable beta");
      current_statement__ = 12;
      if (logical_eq(tau_prior_dist, -1)) {
        current_statement__ = 11;
        assign(tau, nil_index_list(), tau_prior_stan[(1 - 1)],
          "assigning variable tau");
      } else {
        current_statement__ = 10;
        assign(tau, nil_index_list(),
          stan::math::exp(
            add(tau_raw_guess[(1 - 1)],
              multiply(tau_raw_guess[(2 - 1)], tau_raw))),
          "assigning variable tau");
      }
      current_statement__ = 13;
      assign(tau_group, nil_index_list(),
        rvalue(tau,
          cons_list(index_multi(tau_strata_gindex), nil_index_list()), "tau"),
        "assigning variable tau_group");
      current_statement__ = 16;
      if (ncp) {
        current_statement__ = 15;
        assign(eta, nil_index_list(), elt_multiply(xi_eta, tau_group),
          "assigning variable eta");
      } else {
        current_statement__ = 14;
        assign(eta, nil_index_list(),
          add(beta_raw_guess[(1 - 1)][(1 - 1)],
            multiply(beta_raw_guess[(2 - 1)][(1 - 1)], xi_eta)),
          "assigning variable eta");
      }
      current_statement__ = 17;
      assign(theta, nil_index_list(),
        add(multiply(X_param, beta),
          rvalue(eta, cons_list(index_multi(group_index), nil_index_list()),
            "eta")), "assigning variable theta");
      {
        current_statement__ = 40;
        if (ncp) {
          current_statement__ = 36;
          if (logical_eq(re_dist, 0)) {
            current_statement__ = 35;
            lp_accum__.add(normal_lpdf<propto__>(xi_eta, 0, 1));
          } 
          current_statement__ = 38;
          if (logical_eq(re_dist, 1)) {
            current_statement__ = 37;
            lp_accum__.add(
              student_t_lpdf<propto__>(xi_eta, re_dist_t_df, 0, 1));
          } 
        } else {
          current_statement__ = 31;
          if (logical_eq(re_dist, 0)) {
            current_statement__ = 30;
            lp_accum__.add(
              normal_lpdf<propto__>(xi_eta,
                ((beta[(1 - 1)] - beta_raw_guess[(1 - 1)][(1 - 1)]) /
                  beta_raw_guess[(2 - 1)][(1 - 1)]),
                divide(tau_group, beta_raw_guess[(2 - 1)][(1 - 1)])));
          } 
          current_statement__ = 33;
          if (logical_eq(re_dist, 1)) {
            current_statement__ = 32;
            lp_accum__.add(
              student_t_lpdf<propto__>(xi_eta, re_dist_t_df,
                ((beta[(1 - 1)] - beta_raw_guess[(1 - 1)][(1 - 1)]) /
                  beta_raw_guess[(2 - 1)][(1 - 1)]),
                divide(tau_group, beta_raw_guess[(2 - 1)][(1 - 1)])));
          } 
        }
        current_statement__ = 41;
        lp_accum__.add(
          normal_lpdf<propto__>(beta, beta_prior_stan[(1 - 1)],
            beta_prior_stan[(2 - 1)]));
        current_statement__ = 43;
        if (logical_eq(tau_prior_dist, -1)) {
          current_statement__ = 42;
          lp_accum__.add(normal_lpdf<propto__>(tau_raw, 0, 1));
        } 
        current_statement__ = 45;
        if (logical_eq(tau_prior_dist, 0)) {
          current_statement__ = 44;
          lp_accum__.add(
            normal_lpdf<propto__>(tau, 0, tau_prior_stan[(2 - 1)]));
        } 
        current_statement__ = 47;
        if (logical_eq(tau_prior_dist, 1)) {
          current_statement__ = 46;
          lp_accum__.add(
            normal_lpdf<propto__>(tau, tau_prior_stan[(1 - 1)],
              tau_prior_stan[(2 - 1)]));
        } 
        current_statement__ = 49;
        if (logical_eq(tau_prior_dist, 2)) {
          current_statement__ = 48;
          lp_accum__.add(
            uniform_lpdf<propto__>(tau, tau_prior_stan[(1 - 1)],
              tau_prior_stan[(2 - 1)]));
        } 
        current_statement__ = 51;
        if (logical_eq(tau_prior_dist, 3)) {
          current_statement__ = 50;
          lp_accum__.add(
            gamma_lpdf<propto__>(tau, tau_prior_stan[(1 - 1)],
              tau_prior_stan[(2 - 1)]));
        } 
        current_statement__ = 53;
        if (logical_eq(tau_prior_dist, 4)) {
          current_statement__ = 52;
          lp_accum__.add(
            inv_gamma_lpdf<propto__>(tau, tau_prior_stan[(1 - 1)],
              tau_prior_stan[(2 - 1)]));
        } 
        current_statement__ = 55;
        if (logical_eq(tau_prior_dist, 5)) {
          current_statement__ = 54;
          lp_accum__.add(
            lognormal_lpdf<propto__>(tau, tau_prior_stan[(1 - 1)],
              tau_prior_stan[(2 - 1)]));
        } 
        current_statement__ = 57;
        if (logical_eq(tau_prior_dist, 6)) {
          current_statement__ = 56;
          lp_accum__.add(
            cauchy_lpdf<propto__>(tau, tau_prior_stan[(1 - 1)],
              tau_prior_stan[(2 - 1)]));
        } 
        current_statement__ = 59;
        if (logical_eq(tau_prior_dist, 7)) {
          current_statement__ = 58;
          lp_accum__.add(
            exponential_lpdf<propto__>(tau, tau_prior_stan[(1 - 1)]));
        } 
        current_statement__ = 61;
        if (logical_neq(tau_prior_dist, -1)) {
          current_statement__ = 60;
          lp_accum__.add(multiply(tau_raw_guess[(2 - 1)], tau_raw));
        } 
        current_statement__ = 69;
        if (logical_negation(prior_PD)) {
          current_statement__ = 63;
          if (logical_eq(link, 1)) {
            current_statement__ = 62;
            lp_accum__.add(normal_lpdf<propto__>(y, theta, y_se));
          } 
          current_statement__ = 65;
          if (logical_eq(link, 2)) {
            current_statement__ = 64;
            lp_accum__.add(binomial_logit_lpmf<propto__>(r, r_n, theta));
          } 
          current_statement__ = 67;
          if (logical_eq(link, 3)) {
            current_statement__ = 66;
            lp_accum__.add(
              poisson_log_lpmf<propto__>(count, add(log_offset, theta)));
          } 
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_gMAP_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, 1>(mX);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta_raw = in__.vector(mX);
      Eigen::Matrix<double, -1, 1> tau_raw;
      tau_raw = Eigen::Matrix<double, -1, 1>(n_tau_strata);
      stan::math::fill(tau_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      tau_raw = in__.vector(n_tau_strata);
      Eigen::Matrix<double, -1, 1> xi_eta;
      xi_eta = Eigen::Matrix<double, -1, 1>(n_groups);
      stan::math::fill(xi_eta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      xi_eta = in__.vector(n_groups);
      Eigen::Matrix<double, -1, 1> theta;
      theta = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> eta;
      eta = Eigen::Matrix<double, -1, 1>(n_groups);
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(mX);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> tau;
      tau = Eigen::Matrix<double, -1, 1>(n_tau_strata);
      stan::math::fill(tau, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> tau_group;
      tau_group = Eigen::Matrix<double, -1, 1>(n_groups);
      stan::math::fill(tau_group, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
        vars__.emplace_back(beta_raw[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_tau_strata; ++sym1__) {
        vars__.emplace_back(tau_raw[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
        vars__.emplace_back(xi_eta[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 9;
      assign(beta, nil_index_list(),
        add(beta_raw_guess[(1 - 1)],
          elt_multiply(beta_raw_guess[(2 - 1)], beta_raw)),
        "assigning variable beta");
      current_statement__ = 12;
      if (logical_eq(tau_prior_dist, -1)) {
        current_statement__ = 11;
        assign(tau, nil_index_list(), tau_prior_stan[(1 - 1)],
          "assigning variable tau");
      } else {
        current_statement__ = 10;
        assign(tau, nil_index_list(),
          stan::math::exp(
            add(tau_raw_guess[(1 - 1)],
              multiply(tau_raw_guess[(2 - 1)], tau_raw))),
          "assigning variable tau");
      }
      current_statement__ = 13;
      assign(tau_group, nil_index_list(),
        rvalue(tau,
          cons_list(index_multi(tau_strata_gindex), nil_index_list()), "tau"),
        "assigning variable tau_group");
      current_statement__ = 16;
      if (ncp) {
        current_statement__ = 15;
        assign(eta, nil_index_list(), elt_multiply(xi_eta, tau_group),
          "assigning variable eta");
      } else {
        current_statement__ = 14;
        assign(eta, nil_index_list(),
          add(beta_raw_guess[(1 - 1)][(1 - 1)],
            multiply(beta_raw_guess[(2 - 1)][(1 - 1)], xi_eta)),
          "assigning variable eta");
      }
      current_statement__ = 17;
      assign(theta, nil_index_list(),
        add(multiply(X_param, beta),
          rvalue(eta, cons_list(index_multi(group_index), nil_index_list()),
            "eta")), "assigning variable theta");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          vars__.emplace_back(theta[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
          vars__.emplace_back(eta[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
          vars__.emplace_back(beta[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_tau_strata; ++sym1__) {
          vars__.emplace_back(tau[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
          vars__.emplace_back(tau_group[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      double theta_pred;
      theta_pred = std::numeric_limits<double>::quiet_NaN();
      
      double theta_resp_pred;
      theta_resp_pred = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 21;
      if (logical_eq(re_dist, 0)) {
        current_statement__ = 20;
        theta_pred = normal_rng(beta[(1 - 1)], tau[(tau_strata_pred - 1)],
                       base_rng__);
      } 
      current_statement__ = 23;
      if (logical_eq(re_dist, 1)) {
        current_statement__ = 22;
        theta_pred = student_t_rng(re_dist_t_df, beta[(1 - 1)],
                       tau[(tau_strata_pred - 1)], base_rng__);
      } 
      current_statement__ = 25;
      if (logical_eq(link, 1)) {
        current_statement__ = 24;
        theta_resp_pred = theta_pred;
      } 
      current_statement__ = 27;
      if (logical_eq(link, 2)) {
        current_statement__ = 26;
        theta_resp_pred = inv_logit(theta_pred);
      } 
      current_statement__ = 29;
      if (logical_eq(link, 3)) {
        current_statement__ = 28;
        theta_resp_pred = stan::math::exp(theta_pred);
      } 
      vars__.emplace_back(theta_pred);
      vars__.emplace_back(theta_resp_pred);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, 1>(mX);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 1;
        assign(beta_raw_flat__, nil_index_list(),
          context__.vals_r("beta_raw"), "assigning variable beta_raw_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
          current_statement__ = 1;
          assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
            beta_raw_flat__[(pos__ - 1)], "assigning variable beta_raw");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> tau_raw;
      tau_raw = Eigen::Matrix<double, -1, 1>(n_tau_strata);
      stan::math::fill(tau_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tau_raw_flat__;
        current_statement__ = 2;
        assign(tau_raw_flat__, nil_index_list(), context__.vals_r("tau_raw"),
          "assigning variable tau_raw_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= n_tau_strata; ++sym1__) {
          current_statement__ = 2;
          assign(tau_raw, cons_list(index_uni(sym1__), nil_index_list()),
            tau_raw_flat__[(pos__ - 1)], "assigning variable tau_raw");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> xi_eta;
      xi_eta = Eigen::Matrix<double, -1, 1>(n_groups);
      stan::math::fill(xi_eta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xi_eta_flat__;
        current_statement__ = 3;
        assign(xi_eta_flat__, nil_index_list(), context__.vals_r("xi_eta"),
          "assigning variable xi_eta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
          current_statement__ = 3;
          assign(xi_eta, cons_list(index_uni(sym1__), nil_index_list()),
            xi_eta_flat__[(pos__ - 1)], "assigning variable xi_eta");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
        vars__.emplace_back(beta_raw[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_tau_strata; ++sym1__) {
        vars__.emplace_back(tau_raw[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
        vars__.emplace_back(xi_eta[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta_raw");
    names__.emplace_back("tau_raw");
    names__.emplace_back("xi_eta");
    names__.emplace_back("theta");
    names__.emplace_back("eta");
    names__.emplace_back("beta");
    names__.emplace_back("tau");
    names__.emplace_back("tau_group");
    names__.emplace_back("theta_pred");
    names__.emplace_back("theta_resp_pred");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mX)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(n_tau_strata)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_groups)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(H)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_groups)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mX)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(n_tau_strata)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_groups)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_tau_strata; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_raw" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "xi_eta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_tau_strata; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "tau_group" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "theta_pred");
      param_names__.emplace_back(std::string() + "theta_resp_pred");
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_tau_strata; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_raw" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "xi_eta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= mX; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_tau_strata; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_groups; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "tau_group" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "theta_pred");
      param_names__.emplace_back(std::string() + "theta_resp_pred");
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta_raw\",\"type\":{\"name\":\"vector\",\"length\":" << mX << "},\"block\":\"parameters\"},{\"name\":\"tau_raw\",\"type\":{\"name\":\"vector\",\"length\":" << n_tau_strata << "},\"block\":\"parameters\"},{\"name\":\"xi_eta\",\"type\":{\"name\":\"vector\",\"length\":" << n_groups << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"vector\",\"length\":" << H << "},\"block\":\"transformed_parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" << n_groups << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << mX << "},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"vector\",\"length\":" << n_tau_strata << "},\"block\":\"transformed_parameters\"},{\"name\":\"tau_group\",\"type\":{\"name\":\"vector\",\"length\":" << n_groups << "},\"block\":\"transformed_parameters\"},{\"name\":\"theta_pred\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"theta_resp_pred\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta_raw\",\"type\":{\"name\":\"vector\",\"length\":" << mX << "},\"block\":\"parameters\"},{\"name\":\"tau_raw\",\"type\":{\"name\":\"vector\",\"length\":" << n_tau_strata << "},\"block\":\"parameters\"},{\"name\":\"xi_eta\",\"type\":{\"name\":\"vector\",\"length\":" << n_groups << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"vector\",\"length\":" << H << "},\"block\":\"transformed_parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" << n_groups << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << mX << "},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"vector\",\"length\":" << n_tau_strata << "},\"block\":\"transformed_parameters\"},{\"name\":\"tau_group\",\"type\":{\"name\":\"vector\",\"length\":" << n_groups << "},\"block\":\"transformed_parameters\"},{\"name\":\"theta_pred\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"theta_resp_pred\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_gMAP_namespace::model_gMAP;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_gMAP_namespace::profiles__;
}
#endif
#endif
